/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyMethodExtractor;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyMethodExtractorImpl;
import org.socialsignin.spring.data.dynamodb.repository.support.HashAndRangeKeyExtractor;
import org.springframework.util.ReflectionUtils;

public class CompositeIdHashAndRangeKeyExtractor<ID extends Serializable, H>
implements HashAndRangeKeyExtractor<ID, H> {
    private DynamoDBHashAndRangeKeyMethodExtractor<ID> hashAndRangeKeyMethodExtractor;

    public CompositeIdHashAndRangeKeyExtractor(Class<ID> idClass) {
        this.hashAndRangeKeyMethodExtractor = new DynamoDBHashAndRangeKeyMethodExtractorImpl<ID>(idClass);
    }

    @Override
    public H getHashKey(ID id) {
        Method method = this.hashAndRangeKeyMethodExtractor.getHashKeyMethod();
        if (method != null) {
            return (H)ReflectionUtils.invokeMethod((Method)method, id);
        }
        return (H)ReflectionUtils.getField((Field)this.hashAndRangeKeyMethodExtractor.getHashKeyField(), id);
    }

    @Override
    public Object getRangeKey(ID id) {
        Method method = this.hashAndRangeKeyMethodExtractor.getRangeKeyMethod();
        if (method != null) {
            return ReflectionUtils.invokeMethod((Method)method, id);
        }
        return ReflectionUtils.getField((Field)this.hashAndRangeKeyMethodExtractor.getRangeKeyField(), id);
    }
}

