/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import java.io.Serializable;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.query.Query;
import org.socialsignin.spring.data.dynamodb.repository.query.AbstractDynamoDBQuery;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBCountQueryCreator;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryCreator;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeDynamoDBQuery<T, ID extends Serializable>
extends AbstractDynamoDBQuery<T, ID>
implements RepositoryQuery {
    private DynamoDBQueryMethod<T, ID> queryMethod;
    private final Parameters<?, ?> parameters;
    private final PartTree tree;

    public PartTreeDynamoDBQuery(DynamoDBOperations dynamoDBOperations, DynamoDBQueryMethod<T, ID> method) {
        super(dynamoDBOperations, method);
        this.queryMethod = method;
        this.parameters = method.getParameters();
        this.tree = new PartTree(method.getName(), method.getEntityType());
    }

    protected DynamoDBQueryCreator<T, ID> createQueryCreator(ParametersParameterAccessor accessor) {
        return new DynamoDBQueryCreator(this.tree, (ParameterAccessor)accessor, this.queryMethod.getEntityInformation(), this.dynamoDBOperations);
    }

    protected DynamoDBCountQueryCreator<T, ID> createCountQueryCreator(ParametersParameterAccessor accessor, boolean pageQuery) {
        return new DynamoDBCountQueryCreator(this.tree, (ParameterAccessor)accessor, this.queryMethod.getEntityInformation(), this.dynamoDBOperations, pageQuery);
    }

    @Override
    public Query<T> doCreateQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
        DynamoDBQueryCreator<T, ID> queryCreator = this.createQueryCreator(accessor);
        return (Query)queryCreator.createQuery();
    }

    @Override
    public Query<Long> doCreateCountQuery(Object[] values, boolean pageQuery) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
        DynamoDBCountQueryCreator<T, ID> queryCreator = this.createCountQueryCreator(accessor, pageQuery);
        return (Query)queryCreator.createQuery();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected Integer getResultsRestrictionIfApplicable() {
        if (this.tree.isLimiting()) {
            return this.tree.getMaxResults();
        }
        return null;
    }

    @Override
    protected boolean isSingleEntityResultsRestriction() {
        Integer resultsRestiction = this.getResultsRestrictionIfApplicable();
        return resultsRestiction != null && resultsRestiction == 1;
    }
}

