/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryMethod;
import org.socialsignin.spring.data.dynamodb.repository.query.PartTreeDynamoDBQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class DynamoDBQueryLookupStrategy {
    private DynamoDBQueryLookupStrategy() {
    }

    public static QueryLookupStrategy create(DynamoDBOperations dynamoDBOperations, QueryLookupStrategy.Key key) {
        if (key == null) {
            return new CreateQueryLookupStrategy(dynamoDBOperations);
        }
        switch (key) {
            case CREATE: {
                return new CreateQueryLookupStrategy(dynamoDBOperations);
            }
            case USE_DECLARED_QUERY: {
                throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", key));
            }
            case CREATE_IF_NOT_FOUND: {
                return new CreateIfNotFoundQueryLookupStrategy(dynamoDBOperations);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", key));
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy strategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(DynamoDBOperations dynamoDBOperations) {
            super(dynamoDBOperations);
            this.strategy = new DeclaredQueryLookupStrategy(dynamoDBOperations);
            this.createStrategy = new CreateQueryLookupStrategy(dynamoDBOperations);
        }

        @Override
        protected <T, ID extends Serializable> RepositoryQuery createDynamoDBQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, Class<T> entityClass, Class<ID> idClass, NamedQueries namedQueries) {
            try {
                return this.strategy.createDynamoDBQuery(method, metadata, factory, entityClass, idClass, namedQueries);
            }
            catch (IllegalStateException | UnsupportedOperationException e) {
                return this.createStrategy.createDynamoDBQuery(method, metadata, factory, entityClass, idClass, namedQueries);
            }
        }
    }

    private static class DeclaredQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        public DeclaredQueryLookupStrategy(DynamoDBOperations dynamoDBOperations) {
            super(dynamoDBOperations);
        }

        @Override
        protected <T, ID extends Serializable> RepositoryQuery createDynamoDBQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, Class<T> entityClass, Class<ID> idClass, NamedQueries namedQueries) {
            throw new UnsupportedOperationException("Declared Queries not supported at this time");
        }
    }

    private static class CreateQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        public CreateQueryLookupStrategy(DynamoDBOperations dynamoDBOperations) {
            super(dynamoDBOperations);
        }

        @Override
        protected <T, ID extends Serializable> RepositoryQuery createDynamoDBQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, Class<T> entityClass, Class<ID> idClass, NamedQueries namedQueries) {
            try {
                return new PartTreeDynamoDBQuery(this.dynamoDBOperations, new DynamoDBQueryMethod(method, metadata, factory));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Could not create query metamodel for method %s!", method.toString()), e);
            }
        }
    }

    private static abstract class AbstractQueryLookupStrategy
    implements QueryLookupStrategy {
        protected DynamoDBOperations dynamoDBOperations;

        public AbstractQueryLookupStrategy(DynamoDBOperations dynamoDBOperations) {
            this.dynamoDBOperations = dynamoDBOperations;
        }

        public final RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            return this.createDynamoDBQuery(method, metadata, factory, metadata.getDomainType(), metadata.getIdType(), namedQueries);
        }

        protected abstract <T, ID extends Serializable> RepositoryQuery createDynamoDBQuery(Method var1, RepositoryMetadata var2, ProjectionFactory var3, Class<T> var4, Class<ID> var5, NamedQueries var6);
    }
}

