/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.marshaller.Date2IsoDynamoDBMarshaller;
import org.socialsignin.spring.data.dynamodb.marshaller.Instant2IsoDynamoDBMarshaller;
import org.socialsignin.spring.data.dynamodb.query.Query;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryCriteria;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractDynamoDBQueryCriteria<T, ID extends Serializable>
implements DynamoDBQueryCriteria<T, ID> {
    protected Class<T> clazz;
    private DynamoDBEntityInformation<T, ID> entityInformation;
    private Map<String, String> attributeNamesByPropertyName;
    private final DynamoDBMapperTableModel<T> tableModel;
    private String hashKeyPropertyName;
    protected MultiValueMap<String, Condition> attributeConditions;
    protected MultiValueMap<String, Condition> propertyConditions;
    protected Object hashKeyAttributeValue;
    protected Object hashKeyPropertyValue;
    protected String globalSecondaryIndexName;
    protected Sort sort = null;

    public abstract boolean isApplicableForLoad();

    protected QueryRequest buildQueryRequest(String tableName, String theIndexName, String hashKeyAttributeName, String rangeKeyAttributeName, String rangeKeyPropertyName, List<Condition> hashKeyConditions, List<Condition> rangeKeyConditions) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setTableName(tableName);
        queryRequest.setIndexName(theIndexName);
        if (this.isApplicableForGlobalSecondaryIndex()) {
            ArrayList<Object> allowedSortProperties = new ArrayList<Object>();
            for (Map.Entry singlePropertyCondition : this.propertyConditions.entrySet()) {
                if (!this.entityInformation.getGlobalSecondaryIndexNamesByPropertyName().keySet().contains(singlePropertyCondition.getKey())) continue;
                allowedSortProperties.add(singlePropertyCondition.getKey());
            }
            HashMap<String, Condition> keyConditions = new HashMap<String, Condition>();
            if (hashKeyConditions != null && hashKeyConditions.size() > 0) {
                for (Condition hashKeyCondition : hashKeyConditions) {
                    keyConditions.put(hashKeyAttributeName, hashKeyCondition);
                    allowedSortProperties.add(this.hashKeyPropertyName);
                }
            }
            if (rangeKeyConditions != null && rangeKeyConditions.size() > 0) {
                for (Condition rangeKeyCondition : rangeKeyConditions) {
                    keyConditions.put(rangeKeyAttributeName, rangeKeyCondition);
                    allowedSortProperties.add(rangeKeyPropertyName);
                }
            }
            for (Map.Entry singleAttributeConditions : this.attributeConditions.entrySet()) {
                for (Condition condition : (List)singleAttributeConditions.getValue()) {
                    keyConditions.put((String)singleAttributeConditions.getKey(), condition);
                }
            }
            if (this.sort != null) {
                for (Sort.Order order : this.sort) {
                    String sortProperty = order.getProperty();
                    if (!this.entityInformation.isGlobalIndexRangeKeyProperty(sortProperty)) continue;
                    allowedSortProperties.add(sortProperty);
                }
            }
            queryRequest.setKeyConditions(keyConditions);
            queryRequest.setSelect(Select.ALL_PROJECTED_ATTRIBUTES);
            this.applySortIfSpecified(queryRequest, new ArrayList<String>(new HashSet(allowedSortProperties)));
        }
        return queryRequest;
    }

    protected void applySortIfSpecified(DynamoDBQueryExpression<T> queryExpression, List<String> permittedPropertyNames) {
        if (permittedPropertyNames.size() > 1) {
            throw new UnsupportedOperationException("Can only sort by at most a single range or index range key");
        }
        boolean sortAlreadySet = false;
        if (this.sort != null) {
            for (Sort.Order order : this.sort) {
                if (permittedPropertyNames.contains(order.getProperty())) {
                    if (sortAlreadySet) {
                        throw new UnsupportedOperationException("Sorting by multiple attributes not possible");
                    }
                    queryExpression.setScanIndexForward(order.getDirection().equals((Object)Sort.Direction.ASC));
                    sortAlreadySet = true;
                    continue;
                }
                throw new UnsupportedOperationException("Sorting only possible by " + permittedPropertyNames + " for the criteria specified");
            }
        }
    }

    protected void applySortIfSpecified(QueryRequest queryRequest, List<String> permittedPropertyNames) {
        if (permittedPropertyNames.size() > 2) {
            throw new UnsupportedOperationException("Can only sort by at most a single global hash and range key");
        }
        boolean sortAlreadySet = false;
        if (this.sort != null) {
            for (Sort.Order order : this.sort) {
                if (permittedPropertyNames.contains(order.getProperty())) {
                    if (sortAlreadySet) {
                        throw new UnsupportedOperationException("Sorting by multiple attributes not possible");
                    }
                    if (queryRequest.getKeyConditions().size() > 1 && !this.hasIndexHashKeyEqualCondition()) {
                        throw new UnsupportedOperationException("Sorting for global index queries with criteria on both hash and range not possible");
                    }
                    queryRequest.setScanIndexForward(Boolean.valueOf(order.getDirection().equals((Object)Sort.Direction.ASC)));
                    sortAlreadySet = true;
                    continue;
                }
                throw new UnsupportedOperationException("Sorting only possible by " + permittedPropertyNames + " for the criteria specified");
            }
        }
    }

    public boolean comparisonOperatorsPermittedForQuery() {
        List<ComparisonOperator> comparisonOperatorsPermittedForQuery = Arrays.asList(ComparisonOperator.EQ, ComparisonOperator.LE, ComparisonOperator.LT, ComparisonOperator.GE, ComparisonOperator.GT, ComparisonOperator.BEGINS_WITH, ComparisonOperator.BETWEEN);
        for (Collection conditions : this.attributeConditions.values()) {
            for (Condition condition : conditions) {
                if (comparisonOperatorsPermittedForQuery.contains(ComparisonOperator.fromValue((String)condition.getComparisonOperator()))) continue;
                return false;
            }
        }
        return true;
    }

    protected List<Condition> getHashKeyConditions() {
        List hashKeyConditions = null;
        if (this.isApplicableForGlobalSecondaryIndex() && this.entityInformation.getGlobalSecondaryIndexNamesByPropertyName().keySet().contains(this.getHashKeyPropertyName())) {
            List list = hashKeyConditions = this.getHashKeyAttributeValue() == null ? null : Arrays.asList(this.createSingleValueCondition(this.getHashKeyPropertyName(), ComparisonOperator.EQ, this.getHashKeyAttributeValue(), this.getHashKeyAttributeValue().getClass(), true));
            if (hashKeyConditions == null && this.attributeConditions.containsKey((Object)this.getHashKeyAttributeName())) {
                hashKeyConditions = (List)this.attributeConditions.get((Object)this.getHashKeyAttributeName());
            }
        }
        return hashKeyConditions;
    }

    public AbstractDynamoDBQueryCriteria(DynamoDBEntityInformation<T, ID> dynamoDBEntityInformation, DynamoDBMapperTableModel<T> tableModel) {
        this.clazz = dynamoDBEntityInformation.getJavaType();
        this.attributeConditions = new LinkedMultiValueMap();
        this.propertyConditions = new LinkedMultiValueMap();
        this.hashKeyPropertyName = dynamoDBEntityInformation.getHashKeyPropertyName();
        this.entityInformation = dynamoDBEntityInformation;
        this.attributeNamesByPropertyName = new HashMap<String, String>();
        this.tableModel = tableModel;
    }

    private String getFirstDeclaredIndexNameForAttribute(Map<String, String[]> indexNamesByAttributeName, List<String> indexNamesToCheck, String attributeName) {
        String[] declaredOrderedIndexNamesForAttribute;
        String indexName = null;
        for (String declaredOrderedIndexNameForAttribute : declaredOrderedIndexNamesForAttribute = indexNamesByAttributeName.get(attributeName)) {
            if (indexName != null || !indexNamesToCheck.contains(declaredOrderedIndexNameForAttribute)) continue;
            indexName = declaredOrderedIndexNameForAttribute;
        }
        return indexName;
    }

    protected String getGlobalSecondaryIndexName() {
        if (this.globalSecondaryIndexName == null && this.attributeConditions != null && !this.attributeConditions.isEmpty()) {
            HashMap<String, String[]> indexNamesByAttributeName = new HashMap<String, String[]>();
            LinkedMultiValueMap attributeListsByIndexName = new LinkedMultiValueMap();
            for (Map.Entry indexNamesForPropertyNameEntry : this.entityInformation.getGlobalSecondaryIndexNamesByPropertyName().entrySet()) {
                String propertyName = (String)indexNamesForPropertyNameEntry.getKey();
                String attributeName = this.getAttributeName(propertyName);
                indexNamesByAttributeName.put(attributeName, (String[])indexNamesForPropertyNameEntry.getValue());
                for (String indexNameForPropertyName : (String[])indexNamesForPropertyNameEntry.getValue()) {
                    attributeListsByIndexName.add((Object)indexNameForPropertyName, (Object)attributeName);
                }
            }
            ArrayList<String> exactMatchIndexNames = new ArrayList<String>();
            ArrayList<String> partialMatchIndexNames = new ArrayList<String>();
            for (Map.Entry attributeListForIndexNameEntry : attributeListsByIndexName.entrySet()) {
                String indexNameForAttributeList = (String)attributeListForIndexNameEntry.getKey();
                List attributeList = (List)attributeListForIndexNameEntry.getValue();
                if (!attributeList.containsAll(this.attributeConditions.keySet())) continue;
                if (this.attributeConditions.keySet().containsAll(attributeList)) {
                    exactMatchIndexNames.add(indexNameForAttributeList);
                    continue;
                }
                partialMatchIndexNames.add(indexNameForAttributeList);
            }
            if (exactMatchIndexNames.size() > 1) {
                throw new RuntimeException("Multiple indexes defined on same attribute set:" + this.attributeConditions.keySet());
            }
            if (exactMatchIndexNames.size() == 1) {
                this.globalSecondaryIndexName = (String)exactMatchIndexNames.get(0);
            } else if (partialMatchIndexNames.size() > 1) {
                if (this.attributeConditions.size() == 1) {
                    this.globalSecondaryIndexName = this.getFirstDeclaredIndexNameForAttribute(indexNamesByAttributeName, partialMatchIndexNames, (String)this.attributeConditions.keySet().iterator().next());
                }
                if (this.globalSecondaryIndexName == null) {
                    this.globalSecondaryIndexName = (String)partialMatchIndexNames.get(0);
                }
            } else if (partialMatchIndexNames.size() == 1) {
                this.globalSecondaryIndexName = (String)partialMatchIndexNames.get(0);
            }
        }
        return this.globalSecondaryIndexName;
    }

    protected boolean isHashKeyProperty(String propertyName) {
        return this.hashKeyPropertyName.equals(propertyName);
    }

    protected String getHashKeyPropertyName() {
        return this.hashKeyPropertyName;
    }

    protected String getHashKeyAttributeName() {
        return this.getAttributeName(this.getHashKeyPropertyName());
    }

    protected boolean hasIndexHashKeyEqualCondition() {
        boolean hasIndexHashKeyEqualCondition = false;
        for (Map.Entry propertyConditionList : this.propertyConditions.entrySet()) {
            if (!this.entityInformation.isGlobalIndexHashKeyProperty((String)propertyConditionList.getKey())) continue;
            for (Condition condition : (List)propertyConditionList.getValue()) {
                if (!condition.getComparisonOperator().equals(ComparisonOperator.EQ.name())) continue;
                hasIndexHashKeyEqualCondition = true;
            }
        }
        if (this.hashKeyAttributeValue != null && this.entityInformation.isGlobalIndexHashKeyProperty(this.hashKeyPropertyName)) {
            hasIndexHashKeyEqualCondition = true;
        }
        return hasIndexHashKeyEqualCondition;
    }

    protected boolean hasIndexRangeKeyCondition() {
        boolean hasIndexRangeKeyCondition = false;
        for (Map.Entry propertyConditionList : this.propertyConditions.entrySet()) {
            if (!this.entityInformation.isGlobalIndexRangeKeyProperty((String)propertyConditionList.getKey())) continue;
            hasIndexRangeKeyCondition = true;
        }
        if (this.hashKeyAttributeValue != null && this.entityInformation.isGlobalIndexRangeKeyProperty(this.hashKeyPropertyName)) {
            hasIndexRangeKeyCondition = true;
        }
        return hasIndexRangeKeyCondition;
    }

    protected boolean isApplicableForGlobalSecondaryIndex() {
        boolean global;
        boolean bl = global = this.getGlobalSecondaryIndexName() != null;
        if (global && this.getHashKeyAttributeValue() != null && !this.entityInformation.getGlobalSecondaryIndexNamesByPropertyName().keySet().contains(this.getHashKeyPropertyName())) {
            return false;
        }
        int attributeConditionCount = this.attributeConditions.keySet().size();
        boolean attributeConditionsAppropriate = this.hasIndexHashKeyEqualCondition() && (attributeConditionCount == 1 || attributeConditionCount == 2 && this.hasIndexRangeKeyCondition());
        return global && (attributeConditionCount == 0 || attributeConditionsAppropriate) && this.comparisonOperatorsPermittedForQuery();
    }

    public DynamoDBQueryCriteria<T, ID> withHashKeyEquals(Object value) {
        Assert.notNull((Object)value, (String)("Creating conditions on null hash keys not supported: please specify a value for '" + this.getHashKeyPropertyName() + "'"));
        this.hashKeyAttributeValue = this.getPropertyAttributeValue(this.getHashKeyPropertyName(), value);
        this.hashKeyPropertyValue = value;
        return this;
    }

    public boolean isHashKeySpecified() {
        return this.getHashKeyAttributeValue() != null;
    }

    public Object getHashKeyAttributeValue() {
        return this.hashKeyAttributeValue;
    }

    public Object getHashKeyPropertyValue() {
        return this.hashKeyPropertyValue;
    }

    protected String getAttributeName(String propertyName) {
        String attributeName = this.attributeNamesByPropertyName.get(propertyName);
        if (attributeName == null) {
            attributeName = this.entityInformation.getOverriddenAttributeName(propertyName);
            if (attributeName == null) {
                attributeName = propertyName;
            }
            this.attributeNamesByPropertyName.put(propertyName, attributeName);
        }
        return attributeName;
    }

    @Override
    public DynamoDBQueryCriteria<T, ID> withPropertyBetween(String propertyName, Object value1, Object value2, Class<?> type) {
        Condition condition = this.createCollectionCondition(propertyName, ComparisonOperator.BETWEEN, Arrays.asList(value1, value2), type);
        return this.withCondition(propertyName, condition);
    }

    @Override
    public DynamoDBQueryCriteria<T, ID> withPropertyIn(String propertyName, Iterable<?> value, Class<?> propertyType) {
        Condition condition = this.createCollectionCondition(propertyName, ComparisonOperator.IN, value, propertyType);
        return this.withCondition(propertyName, condition);
    }

    @Override
    public DynamoDBQueryCriteria<T, ID> withSingleValueCriteria(String propertyName, ComparisonOperator comparisonOperator, Object value, Class<?> propertyType) {
        if (comparisonOperator.equals((Object)ComparisonOperator.EQ)) {
            return this.withPropertyEquals(propertyName, value, propertyType);
        }
        Condition condition = this.createSingleValueCondition(propertyName, comparisonOperator, value, propertyType, false);
        return this.withCondition(propertyName, condition);
    }

    @Override
    public Query<T> buildQuery(DynamoDBOperations dynamoDBOperations) {
        if (this.isApplicableForLoad()) {
            return this.buildSingleEntityLoadQuery(dynamoDBOperations);
        }
        return this.buildFinderQuery(dynamoDBOperations);
    }

    @Override
    public Query<Long> buildCountQuery(DynamoDBOperations dynamoDBOperations, boolean pageQuery) {
        if (this.isApplicableForLoad()) {
            return this.buildSingleEntityCountQuery(dynamoDBOperations);
        }
        return this.buildFinderCountQuery(dynamoDBOperations, pageQuery);
    }

    protected abstract Query<T> buildSingleEntityLoadQuery(DynamoDBOperations var1);

    protected abstract Query<Long> buildSingleEntityCountQuery(DynamoDBOperations var1);

    protected abstract Query<T> buildFinderQuery(DynamoDBOperations var1);

    protected abstract Query<Long> buildFinderCountQuery(DynamoDBOperations var1, boolean var2);

    protected abstract boolean isOnlyHashKeySpecified();

    @Override
    public DynamoDBQueryCriteria<T, ID> withNoValuedCriteria(String propertyName, ComparisonOperator comparisonOperator) {
        Condition condition = this.createNoValueCondition(propertyName, comparisonOperator);
        return this.withCondition(propertyName, condition);
    }

    public DynamoDBQueryCriteria<T, ID> withCondition(String propertyName, Condition condition) {
        this.attributeConditions.add((Object)this.getAttributeName(propertyName), (Object)condition);
        this.propertyConditions.add((Object)propertyName, (Object)condition);
        return this;
    }

    protected <V> Object getPropertyAttributeValue(String propertyName, V value) {
        String attributeName;
        DynamoDBMapperFieldModel fieldModel;
        DynamoDBMarshaller marshaller = this.entityInformation.getMarshallerForProperty(propertyName);
        if (marshaller != null) {
            return marshaller.marshall(value);
        }
        if (this.tableModel != null && (fieldModel = this.tableModel.field(attributeName = this.getAttributeName(propertyName))) != null) {
            return fieldModel.convert(value);
        }
        return value;
    }

    protected <V> Condition createNoValueCondition(String propertyName, ComparisonOperator comparisonOperator) {
        Condition condition = new Condition().withComparisonOperator(comparisonOperator);
        return condition;
    }

    private List<String> getNumberListAsStringList(List<Number> numberList) {
        ArrayList<String> list = new ArrayList<String>();
        for (Number number : numberList) {
            if (number != null) {
                list.add(number.toString());
                continue;
            }
            list.add(null);
        }
        return list;
    }

    private List<String> getDateListAsStringList(List<Date> dateList) {
        Date2IsoDynamoDBMarshaller marshaller = new Date2IsoDynamoDBMarshaller();
        ArrayList<String> list = new ArrayList<String>();
        for (Date date : dateList) {
            if (date != null) {
                list.add(marshaller.marshall(date));
                continue;
            }
            list.add(null);
        }
        return list;
    }

    private List<String> getInstantListAsStringList(List<Instant> dateList) {
        Instant2IsoDynamoDBMarshaller marshaller = new Instant2IsoDynamoDBMarshaller();
        ArrayList<String> list = new ArrayList<String>();
        for (Instant date : dateList) {
            if (date != null) {
                list.add(marshaller.marshall(date));
                continue;
            }
            list.add(null);
        }
        return list;
    }

    private List<String> getBooleanListAsStringList(List<Boolean> booleanList) {
        ArrayList<String> list = new ArrayList<String>();
        for (Boolean booleanValue : booleanList) {
            if (booleanValue != null) {
                list.add(booleanValue != false ? "1" : "0");
                continue;
            }
            list.add(null);
        }
        return list;
    }

    private <P> List<P> getAttributeValueAsList(Object attributeValue) {
        boolean isIterable = ClassUtils.isAssignable(Iterable.class, attributeValue.getClass());
        if (isIterable) {
            ArrayList attributeValueAsList = new ArrayList();
            Iterable iterable = (Iterable)attributeValue;
            for (Object attributeValueElement : iterable) {
                attributeValueAsList.add(attributeValueElement);
            }
            return attributeValueAsList;
        }
        return null;
    }

    protected <P> List<AttributeValue> addAttributeValue(List<AttributeValue> attributeValueList, Object attributeValue, String propertyName, Class<P> propertyType, boolean expandCollectionValues) {
        AttributeValue attributeValueObject = new AttributeValue();
        if (ClassUtils.isAssignable(String.class, propertyType)) {
            List<P> attributeValueAsList = this.getAttributeValueAsList(attributeValue);
            if (expandCollectionValues && attributeValueAsList != null) {
                attributeValueObject.withSS(attributeValueAsList);
            } else {
                attributeValueObject.withS((String)attributeValue);
            }
        } else if (ClassUtils.isAssignable(Number.class, propertyType)) {
            List<Number> attributeValueAsList = this.getAttributeValueAsList(attributeValue);
            if (expandCollectionValues && attributeValueAsList != null) {
                List<String> attributeValueAsStringList = this.getNumberListAsStringList(attributeValueAsList);
                attributeValueObject.withNS(attributeValueAsStringList);
            } else {
                attributeValueObject.withN(attributeValue.toString());
            }
        } else if (ClassUtils.isAssignable(Boolean.class, propertyType)) {
            List<Boolean> attributeValueAsList = this.getAttributeValueAsList(attributeValue);
            if (expandCollectionValues && attributeValueAsList != null) {
                List<String> attributeValueAsStringList = this.getBooleanListAsStringList(attributeValueAsList);
                attributeValueObject.withNS(attributeValueAsStringList);
            } else {
                boolean boolValue = (Boolean)attributeValue;
                attributeValueObject.withN(boolValue ? "1" : "0");
            }
        } else if (ClassUtils.isAssignable(Date.class, propertyType)) {
            List<Date> attributeValueAsList = this.getAttributeValueAsList(attributeValue);
            if (expandCollectionValues && attributeValueAsList != null) {
                List<String> attributeValueAsStringList = this.getDateListAsStringList(attributeValueAsList);
                attributeValueObject.withSS(attributeValueAsStringList);
            } else {
                Date date = (Date)attributeValue;
                String marshalledDate = new Date2IsoDynamoDBMarshaller().marshall(date);
                attributeValueObject.withS(marshalledDate);
            }
        } else {
            throw new RuntimeException("Cannot create condition for type:" + attributeValue.getClass() + " property conditions must be String,Number or Boolean, or have a DynamoDBMarshaller configured");
        }
        attributeValueList.add(attributeValueObject);
        return attributeValueList;
    }

    protected Condition createSingleValueCondition(String propertyName, ComparisonOperator comparisonOperator, Object o, Class<?> propertyType, boolean alreadyMarshalledIfRequired) {
        Object attributeValue;
        Assert.notNull((Object)o, (String)("Creating conditions on null property values not supported: please specify a value for '" + propertyName + "'"));
        List<AttributeValue> attributeValueList = new ArrayList<AttributeValue>();
        Object object = attributeValue = !alreadyMarshalledIfRequired ? this.getPropertyAttributeValue(propertyName, o) : o;
        if (ClassUtils.isAssignableValue(AttributeValue.class, (Object)attributeValue)) {
            attributeValueList.add((AttributeValue)attributeValue);
        } else {
            boolean marshalled = !alreadyMarshalledIfRequired && attributeValue != o && !this.entityInformation.isCompositeHashAndRangeKeyProperty(propertyName);
            Class targetPropertyType = marshalled ? String.class : propertyType;
            attributeValueList = this.addAttributeValue(attributeValueList, attributeValue, propertyName, targetPropertyType, true);
        }
        return new Condition().withComparisonOperator(comparisonOperator).withAttributeValueList(attributeValueList);
    }

    protected Condition createCollectionCondition(String propertyName, ComparisonOperator comparisonOperator, Iterable<?> o, Class<?> propertyType) {
        Assert.notNull(o, (String)("Creating conditions on null property values not supported: please specify a value for '" + propertyName + "'"));
        List<AttributeValue> attributeValueList = new ArrayList<AttributeValue>();
        boolean marshalled = false;
        for (Object object : o) {
            Object attributeValue = this.getPropertyAttributeValue(propertyName, object);
            if (ClassUtils.isAssignableValue(AttributeValue.class, (Object)attributeValue)) {
                attributeValueList.add((AttributeValue)attributeValue);
                continue;
            }
            if (attributeValue != null) {
                marshalled = attributeValue != object && !this.entityInformation.isCompositeHashAndRangeKeyProperty(propertyName);
            }
            Class targetPropertyType = marshalled ? String.class : propertyType;
            attributeValueList = this.addAttributeValue(attributeValueList, attributeValue, propertyName, targetPropertyType, false);
        }
        return new Condition().withComparisonOperator(comparisonOperator).withAttributeValueList(attributeValueList);
    }

    @Override
    public DynamoDBQueryCriteria<T, ID> withSort(Sort sort) {
        this.sort = sort;
        return this;
    }
}

