/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52.regions;

import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate52.ConfigurableRedisRegionFactory;
import org.hibernate.cache.redis.hibernate52.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.redis.util.CacheTimestamper;
import org.hibernate.cache.redis.util.RedisCacheUtil;
import org.hibernate.cache.spi.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedisDataRegion
implements Region {
    private static final Logger log = LoggerFactory.getLogger(RedisDataRegion.class);
    protected final RedisAccessStrategyFactory accessStrategyFactory;
    private final String regionName;
    protected final RedisClient redis;
    private final CacheTimestamper cacheTimestamper;
    private final int expiryInSeconds;

    public RedisDataRegion(RedisAccessStrategyFactory accessStrategyFactory, RedisClient redis, ConfigurableRedisRegionFactory configurableRedisRegionFactory, String regionName, Properties props) {
        this.accessStrategyFactory = accessStrategyFactory;
        this.redis = redis;
        this.regionName = regionName;
        this.cacheTimestamper = configurableRedisRegionFactory.createCacheTimestamper(redis, regionName);
        this.expiryInSeconds = RedisCacheUtil.getExpiryInSeconds(this.regionName);
        log.debug("redis region={}, expiryInSeconds={}", (Object)regionName, (Object)this.expiryInSeconds);
    }

    public String getName() {
        return this.regionName;
    }

    public void destroy() throws CacheException {
    }

    public boolean contains(Object key) {
        try {
            log.debug("contains key={}", key);
            return this.redis.exists(this.regionName, key);
        }
        catch (Exception ignored) {
            log.warn("Fail to exists key. key=" + key, (Throwable)ignored);
            return false;
        }
    }

    public long getSizeInMemory() {
        try {
            long sizeInMemory = this.redis.dbSize();
            log.trace("size in memory. region={}, size={}", (Object)this.regionName, (Object)sizeInMemory);
            return sizeInMemory;
        }
        catch (Exception ignored) {
            log.warn("Fail to get size in memory.", (Throwable)ignored);
            return 0L;
        }
    }

    public long getElementCountInMemory() {
        try {
            long elementCount = this.redis.keySizeInRegion(this.regionName);
            log.trace("region={}, elementCount={}", (Object)this.regionName, (Object)elementCount);
            return elementCount;
        }
        catch (Exception ignored) {
            log.warn("Fail to get element count in memory", (Throwable)ignored);
            return 0L;
        }
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        return this.redis.getAll(this.regionName);
    }

    public long nextTimestamp() {
        return this.cacheTimestamper.next();
    }

    public int getTimeout() {
        return 0;
    }

    public RedisAccessStrategyFactory getAccessStrategyFactory() {
        return this.accessStrategyFactory;
    }

    public RedisClient getRedis() {
        return this.redis;
    }

    public int getExpiryInSeconds() {
        return this.expiryInSeconds;
    }
}

