/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate5.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate5.regions.RedisCollectionRegion;
import org.hibernate.cache.redis.hibernate5.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalRedisCollectionRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisCollectionRegion>
implements CollectionRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(TransactionalRedisCollectionRegionAccessStrategy.class);
    private final RedisClient redis;

    public TransactionalRedisCollectionRegionAccessStrategy(RedisCollectionRegion region, SessionFactoryOptions options) {
        super(region, options);
        this.redis = region.getRedis();
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.createCollectionKey((Object)id, (CollectionPersister)persister, (SessionFactoryImplementor)factory, (String)tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.getCollectionId((Object)cacheKey);
    }

    public CollectionRegion getRegion() {
        return (CollectionRegion)this.region;
    }

    @Override
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisCollectionRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisCollectionRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public SoftLock lockItem(SessionImplementor session, Object key, Object version) {
        ((RedisCollectionRegion)this.region).remove(key);
        return null;
    }

    @Override
    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) {
        ((RedisCollectionRegion)this.region).remove(key);
    }

    @Override
    public void remove(SessionImplementor session, Object key) {
        ((RedisCollectionRegion)this.region).remove(key);
    }

    public RedisClient getRedis() {
        return this.redis;
    }
}

