/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate5.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.redis.hibernate5.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate5.strategy.AbstractReadWriteRedisAccessStrategy;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteRedisNaturalIdRegionAccessStrategy
extends AbstractReadWriteRedisAccessStrategy<RedisNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteRedisNaturalIdRegionAccessStrategy.class);

    public ReadWriteRedisNaturalIdRegionAccessStrategy(RedisNaturalIdRegion region, SessionFactoryOptions options) {
        super(region, options);
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return DefaultCacheKeysFactory.createNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SessionImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.getNaturalIdValues((Object)cacheKey);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public boolean insert(SessionImplementor session, Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    public boolean update(SessionImplementor session, Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }
}

