/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate5.regions;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate5.ConfigurableRedisRegionFactory;
import org.hibernate.cache.redis.hibernate5.regions.RedisDataRegion;
import org.hibernate.cache.redis.hibernate5.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.engine.spi.SessionImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisGeneralDataRegion
extends RedisDataRegion
implements GeneralDataRegion {
    private static final Logger log = LoggerFactory.getLogger(RedisGeneralDataRegion.class);

    public RedisGeneralDataRegion(RedisAccessStrategyFactory accessStrategyFactory, RedisClient redis, ConfigurableRedisRegionFactory configurableRedisRegionFactory, String regionName, Properties props) {
        super(accessStrategyFactory, redis, configurableRedisRegionFactory, regionName, props);
    }

    public Object get(SessionImplementor session, Object key) throws CacheException {
        try {
            return this.redis.get(this.getName(), key);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void put(SessionImplementor session, Object key, Object value) throws CacheException {
        try {
            this.redis.set(this.getName(), key, value, this.getExpiryInSeconds());
        }
        catch (Exception ignored) {
            log.warn("Fail to put. key=" + key, (Throwable)ignored);
        }
    }

    public void evict(Object key) throws CacheException {
        try {
            this.redis.del(this.getName(), key);
        }
        catch (Exception ignored) {
            log.warn("Fail to evict. key=" + key, (Throwable)ignored);
        }
    }

    public void evictAll() throws CacheException {
        try {
            this.redis.deleteRegion(this.getName());
        }
        catch (Exception ignored) {
            log.warn("Fail to evict all.", (Throwable)ignored);
        }
    }
}

