/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.strategy;

import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate4.regions.RedisCollectionRegion;
import org.hibernate.cache.redis.hibernate4.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalRedisCollectionRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisCollectionRegion>
implements CollectionRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(TransactionalRedisCollectionRegionAccessStrategy.class);
    private final RedisClient redis;

    public TransactionalRedisCollectionRegionAccessStrategy(RedisCollectionRegion region, Settings settings) {
        super(region, settings);
        this.redis = region.getRedis();
    }

    public CollectionRegion getRegion() {
        return (CollectionRegion)this.region;
    }

    public Object get(Object key, long txTimestamp) {
        return ((RedisCollectionRegion)this.region).get(key);
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisCollectionRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisCollectionRegion)this.region).put(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version) {
        ((RedisCollectionRegion)this.region).remove(key);
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) {
        ((RedisCollectionRegion)this.region).remove(key);
    }

    @Override
    public void remove(Object key) {
        ((RedisCollectionRegion)this.region).remove(key);
    }

    public RedisClient getRedis() {
        return this.redis;
    }
}

