/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.strategy;

import org.hibernate.cache.redis.hibernate4.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate4.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRedisNaturalIdRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyRedisNaturalIdRegionAccessStrategy.class);

    public ReadOnlyRedisNaturalIdRegionAccessStrategy(RedisNaturalIdRegion region, Settings settings) {
        super(region, settings);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public Object get(Object key, long txTimestamp) {
        return ((RedisNaturalIdRegion)this.region).get(key);
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisNaturalIdRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version) {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) {
        ((RedisNaturalIdRegion)this.region).remove(key);
    }

    public boolean insert(Object key, Object value) {
        return false;
    }

    public boolean afterInsert(Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    public boolean update(Object key, Object value) {
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public boolean afterUpdate(Object key, Object value, SoftLock lock) {
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }
}

