/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.redisson.api.RMapCache;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClient {
    private static final Logger log = LoggerFactory.getLogger(RedisClient.class);
    private final transient RedissonClient redisson;
    private int expiryInSeconds;
    private final ConcurrentMap<String, RMapCache<Object, Object>> caches = new ConcurrentHashMap<String, RMapCache<Object, Object>>();

    public RedisClient(RedissonClient redisson) {
        this(redisson, 120);
    }

    public RedisClient(@NonNull RedissonClient redisson, int expiryInSeconds) {
        if (redisson == null) {
            throw new NullPointerException("redisson");
        }
        log.trace("RedisClient created. config={}, expiryInSeconds={}", (Object)redisson.getConfig().toJSON(), (Object)expiryInSeconds);
        this.redisson = redisson;
        if (expiryInSeconds >= 0) {
            this.expiryInSeconds = expiryInSeconds;
        }
    }

    public long nextTimestamp(List<Object> keys) {
        return (Long)this.redisson.getScript().eval(RScript.Mode.READ_WRITE, "redis.call('setnx', KEYS[1], ARGV[1]); return redis.call('incr', KEYS[1]);", RScript.ReturnType.INTEGER, keys, new Object[]{System.currentTimeMillis()});
    }

    public long dbSize() {
        return this.redisson.getKeys().count();
    }

    public boolean exists(String region, Object key) {
        return this.getCache(region).containsKey(key);
    }

    public <T> T get(String region, Object key) {
        Object cacheItem = this.getCache(region).get(key);
        log.trace("retrieve cache item. region={}, key={}, value={}", new Object[]{region, key, cacheItem});
        return (T)cacheItem;
    }

    public boolean isExpired(String region, Object key) {
        return this.exists(region, key);
    }

    public Set<Object> keysInRegion(String region) {
        return this.getCache(region).keySet();
    }

    public long keySizeInRegion(String region) {
        return this.getCache(region).size();
    }

    public Map<Object, Object> getAll(String region) {
        return this.getCache(region);
    }

    public void set(String region, Object key, Object value) {
        this.set(region, key, value, this.expiryInSeconds);
    }

    public void set(String region, Object key, Object value, long timeoutInSeconds) {
        this.set(region, key, value, timeoutInSeconds, TimeUnit.SECONDS);
    }

    public void set(String region, Object key, Object value, long timeout, TimeUnit unit) {
        log.trace("set cache item. region={}, key={}, timeout={}, unit={}", new Object[]{region, key, timeout, unit});
        RMapCache<Object, Object> cache = this.getCache(region);
        if (timeout > 0L) {
            cache.fastPut(key, value, timeout, unit);
        } else {
            cache.fastPut(key, value);
        }
    }

    public void expire(String region) {
        this.getCache(region).clearExpire();
    }

    public void del(String region, Object key) {
        this.getCache(region).fastRemove(new Object[]{key});
    }

    public void mdel(String region, Collection<?> keys) {
        this.getCache(region).fastRemove(keys.toArray(new Object[keys.size()]));
    }

    public void deleteRegion(String region) {
        this.getCache(region).clear();
    }

    public void flushDb() {
        log.info("flush db...");
        this.redisson.getKeys().flushdb();
    }

    public boolean isShutdown() {
        return this.redisson.isShutdown();
    }

    public void shutdown() {
        this.redisson.shutdown();
    }

    private RMapCache<Object, Object> getCache(String region) {
        RMapCache<Object, Object> concurrent;
        RMapCache<Object, Object> cache = (RMapCache<Object, Object>)this.caches.get(region);
        if (cache == null && (concurrent = this.caches.putIfAbsent(region, cache = this.redisson.getMapCache(region))) != null) {
            cache = concurrent;
        }
        return cache;
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public int getExpiryInSeconds() {
        return this.expiryInSeconds;
    }

    public void setExpiryInSeconds(int expiryInSeconds) {
        this.expiryInSeconds = expiryInSeconds;
    }
}

