/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.util;

import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.v3.SpecEncrypt;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import me.chanjar.weixin.common.error.WxRuntimeException;

public class RsaCryptoUtil {
    static String JAVA_LANG_STRING = "java.lang.String";

    public static void encryptFields(Object encryptObject, X509Certificate certificate) throws WxPayException {
        try {
            RsaCryptoUtil.encryptField(encryptObject, certificate);
        }
        catch (Exception e) {
            throw new WxPayException("\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private static void encryptField(Object encryptObject, X509Certificate certificate) throws IllegalAccessException, IllegalBlockSizeException {
        Field[] infoFieldArray;
        Class<?> infoClass = encryptObject.getClass();
        for (Field field : infoFieldArray = infoClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SpecEncrypt.class)) continue;
            if (field.getType().getTypeName().equals(JAVA_LANG_STRING)) {
                String oldStr;
                field.setAccessible(true);
                Object oldValue = field.get(encryptObject);
                if (oldValue == null || (oldStr = (String)oldValue).trim().equals("'")) continue;
                field.set(encryptObject, RsaCryptoUtil.encryptOAEP(oldStr, certificate));
                continue;
            }
            field.setAccessible(true);
            Object obj = field.get(encryptObject);
            if (obj == null) continue;
            RsaCryptoUtil.encryptField(field.get(encryptObject), certificate);
        }
    }

    public static String encryptOAEP(String message, X509Certificate certificate) throws IllegalBlockSizeException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, certificate.getPublicKey());
            byte[] data = message.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertext = cipher.doFinal(data);
            return Base64.getEncoder().encodeToString(ciphertext);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new WxRuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
    }

    public static String decryptOAEP(String ciphertext, PrivateKey privateKey) throws BadPaddingException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(2, privateKey);
            byte[] data = Base64.getDecoder().decode(ciphertext);
            return new String(cipher.doFinal(data), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new WxRuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u79c1\u94a5", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new BadPaddingException("\u89e3\u5bc6\u5931\u8d25");
        }
    }
}

