/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.event;

import java.util.Objects;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.jspecify.annotations.Nullable;

final class EventTypeFilter<K, V>
implements CacheEntryEventFilter<K, V> {
    private final CacheEntryEventFilter<? super K, ? super V> filter;
    private final CacheEntryListener<? super K, ? super V> listener;

    public EventTypeFilter(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter) {
        this.listener = Objects.requireNonNull(listener);
        this.filter = Objects.requireNonNull(filter);
    }

    public boolean evaluate(CacheEntryEvent<? extends K, ? extends V> event) {
        return this.isCompatible(event) && this.filter.evaluate(event);
    }

    private boolean isCompatible(CacheEntryEvent<? extends K, ? extends V> event) {
        switch (event.getEventType()) {
            case CREATED: {
                return this.listener instanceof CacheEntryCreatedListener;
            }
            case UPDATED: {
                return this.listener instanceof CacheEntryUpdatedListener;
            }
            case REMOVED: {
                return this.listener instanceof CacheEntryRemovedListener;
            }
            case EXPIRED: {
                return this.listener instanceof CacheEntryExpiredListener;
            }
        }
        throw new CacheEntryListenerException("Unknown event type: " + String.valueOf(event.getEventType()));
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventTypeFilter)) {
            return false;
        }
        EventTypeFilter other = (EventTypeFilter)o;
        return Objects.equals(this.listener, other.listener) && Objects.equals(this.filter, other.filter);
    }

    public int hashCode() {
        return this.filter.hashCode();
    }
}

