/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.extractors;

import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractors;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

class ObjectGettersExtractor<T>
implements SubValuesExtractor<T, Object> {
    private static final Method objectGetClassMethod;
    static final ObjectGettersExtractor INSTANCE;

    private ObjectGettersExtractor() {
    }

    @Override
    public void run(T item, SubValuesExtractor.SubValuesListener<Object> subValuesListener) {
        if (item != null) {
            for (Method method : item.getClass().getMethods()) {
                if (!ObjectGettersExtractor.isGetter(method)) continue;
                SubValuesExtractors.getter(method).run(item, subValuesListener);
            }
        }
    }

    @Override
    public void runForAbsentItem(SubValuesExtractor.SubValuesListener<Object> subValuesListener) {
    }

    private static boolean isGetter(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (method.getParameterCount() > 0) {
            return false;
        }
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        if (!ObjectGettersExtractor.isGetterMethodName(method.getName(), method.getReturnType())) {
            return false;
        }
        return !Objects.equals(method, objectGetClassMethod);
    }

    private static boolean isGetterMethodName(String name, Class<?> returnType) {
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            return true;
        }
        return name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2)) && (returnType == Boolean.TYPE || returnType == Boolean.class);
    }

    static {
        INSTANCE = new ObjectGettersExtractor();
        try {
            objectGetClassMethod = Object.class.getDeclaredMethod("getClass", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

