/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.extractors;

import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import java.util.Map;

class HashMapExtractor<K, V>
implements SubValuesExtractor<Map<K, V>, V> {
    private final K key;

    HashMapExtractor(K key) {
        this.key = key;
    }

    @Override
    public void run(Map<K, V> item, SubValuesExtractor.SubValuesListener<V> subValuesListener) {
        try {
            if (item == null || !item.containsKey(this.key)) {
                subValuesListener.absent(Keys.hashMapKey(this.key));
            } else {
                subValuesListener.present(Keys.hashMapKey(this.key), item.get(this.key));
            }
        }
        catch (ClassCastException e) {
            subValuesListener.broken(Keys.hashMapKey(this.key), e);
        }
    }

    @Override
    public void runForAbsentItem(SubValuesExtractor.SubValuesListener<V> subValuesListener) {
        subValuesListener.absent(Keys.hashMapKey(this.key));
    }
}

