/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.extractors;

import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;

class FieldExtractor<T, S>
implements SubValuesExtractor<T, S> {
    private final Field field;

    FieldExtractor(Field field) {
        Validate.notNull((Object)field, (String)"field", (Object[])new Object[0]);
        this.field = field;
    }

    @Override
    public void run(T item, SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        if (item == null && !Modifier.isStatic(this.field.getModifiers())) {
            subValuesListener.absent(Keys.fieldKey(this.field));
        } else {
            try {
                subValuesListener.present(Keys.fieldKey(this.field), FieldUtils.readField((Field)this.field, item, (boolean)true));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                subValuesListener.broken(Keys.fieldKey(this.field), e);
            }
        }
    }

    @Override
    public void runForAbsentItem(SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        this.run(null, subValuesListener);
    }
}

