/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.extractors;

import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractors;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import java.lang.reflect.Field;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;

class FieldByNameExtractor<T, S>
implements SubValuesExtractor<T, S> {
    private final String fieldName;

    FieldByNameExtractor(String fieldName) {
        Validate.notNull((Object)fieldName, (String)"fieldName", (Object[])new Object[0]);
        this.fieldName = fieldName;
    }

    @Override
    public void run(T item, SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        if (item == null) {
            subValuesListener.absent(Keys.fieldByNameKey(this.fieldName));
        } else {
            Field field;
            try {
                field = FieldUtils.getField(item.getClass(), (String)this.fieldName, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                subValuesListener.broken(Keys.fieldByNameKey(this.fieldName), e);
                return;
            }
            if (field == null) {
                subValuesListener.absent(Keys.fieldByNameKey(this.fieldName));
            } else {
                SubValuesExtractors.field(field).run(item, subValuesListener);
            }
        }
    }

    @Override
    public void runForAbsentItem(SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        subValuesListener.absent(Keys.fieldByNameKey(this.fieldName));
    }
}

