/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.checkers;

import com.github.alkedr.matchers.reporting.ReportingMatcher;
import com.github.alkedr.matchers.reporting.ReportingMatchers;
import com.github.alkedr.matchers.reporting.sub.value.checkers.CompositeSubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.checkers.CompositeSubValuesCheckerSupplier;
import com.github.alkedr.matchers.reporting.sub.value.checkers.ContainsInAnyOrderSubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.checkers.ContainsInSpecifiedOrderSubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.checkers.MatcherSubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.checkers.NoOpSubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.checkers.SubValuesChecker;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;

public enum SubValueCheckers {


    public static Supplier<SubValuesChecker> noOpSubValuesChecker() {
        return () -> NoOpSubValuesChecker.INSTANCE;
    }

    public static SubValuesChecker compositeSubValuesChecker(SubValuesChecker ... subValuesCheckers) {
        return SubValueCheckers.compositeSubValuesChecker(Arrays.asList(subValuesCheckers));
    }

    public static SubValuesChecker compositeSubValuesChecker(Iterable<SubValuesChecker> subValuesCheckers) {
        return new CompositeSubValuesChecker(subValuesCheckers);
    }

    @SafeVarargs
    public static Supplier<SubValuesChecker> compositeSubValuesCheckerSupplier(Supplier<SubValuesChecker> ... subValuesCheckerSuppliers) {
        return SubValueCheckers.compositeSubValuesCheckerSupplier(Arrays.asList(subValuesCheckerSuppliers));
    }

    public static Supplier<SubValuesChecker> compositeSubValuesCheckerSupplier(Iterable<Supplier<SubValuesChecker>> subValuesCheckerSuppliers) {
        return new CompositeSubValuesCheckerSupplier(subValuesCheckerSuppliers);
    }

    public static <T> Supplier<SubValuesChecker> containsInSpecifiedOrder(Iterator<? extends ReportingMatcher<? super T>> elementMatchers) {
        return () -> new ContainsInSpecifiedOrderSubValuesChecker(elementMatchers);
    }

    public static <T> Supplier<SubValuesChecker> containsInSpecifiedOrder(Iterable<? extends ReportingMatcher<? super T>> elementMatchers) {
        return SubValueCheckers.containsInSpecifiedOrder(elementMatchers.iterator());
    }

    @SafeVarargs
    public static <T> Supplier<SubValuesChecker> containsInSpecifiedOrder(T ... elements) {
        return SubValueCheckers.containsInSpecifiedOrder(Arrays.stream(elements).map(element -> ReportingMatchers.toReportingMatcher(CoreMatchers.equalTo((Object)element))).collect(Collectors.toList()));
    }

    public static <T> Supplier<SubValuesChecker> containsInAnyOrder(Iterable<? extends ReportingMatcher<? super T>> elementMatchers) {
        return () -> new ContainsInAnyOrderSubValuesChecker(elementMatchers);
    }

    @SafeVarargs
    public static <T> Supplier<SubValuesChecker> containsInAnyOrder(T ... elements) {
        return SubValueCheckers.containsInAnyOrder(Arrays.stream(elements).map(element -> ReportingMatchers.toReportingMatcher(CoreMatchers.equalTo((Object)element))).collect(Collectors.toList()));
    }

    public static <T> Supplier<SubValuesChecker> matcherSubValuesChecker(ReportingMatcher<? super T> matcherForExtractedValue) {
        return () -> new MatcherSubValuesChecker(matcherForExtractedValue);
    }
}

