/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.checkers;

import com.github.alkedr.matchers.reporting.ReportingMatcher;
import com.github.alkedr.matchers.reporting.reporters.SafeTreeReporter;
import com.github.alkedr.matchers.reporting.sub.value.checkers.SubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;

class ContainsInSpecifiedOrderSubValuesChecker<T>
implements SubValuesChecker {
    private final Iterator<? extends ReportingMatcher<? super T>> elementMatchers;
    private int index = 0;

    ContainsInSpecifiedOrderSubValuesChecker(Iterator<? extends ReportingMatcher<? super T>> elementMatchers) {
        this.elementMatchers = elementMatchers;
    }

    @Override
    public void begin(SafeTreeReporter safeTreeReporter) {
    }

    @Override
    public Consumer<SafeTreeReporter> present(Key key, Object value) {
        return this.value(reportingMatcher -> reporter -> reportingMatcher.run(value, (SafeTreeReporter)reporter));
    }

    @Override
    public Consumer<SafeTreeReporter> absent(Key key) {
        return this.value(reportingMatcher -> reportingMatcher::runForAbsentItem);
    }

    @Override
    public Consumer<SafeTreeReporter> broken(Key key, Throwable throwable) {
        return this.value(reportingMatcher -> reportingMatcher::runForAbsentItem);
    }

    private Consumer<SafeTreeReporter> value(Function<ReportingMatcher<?>, Consumer<SafeTreeReporter>> function) {
        ++this.index;
        if (this.elementMatchers.hasNext()) {
            return function.apply(this.elementMatchers.next());
        }
        return reporter -> {};
    }

    @Override
    public void end(SafeTreeReporter safeTreeReporter) {
        while (this.elementMatchers.hasNext()) {
            ReportingMatcher matcher = this.elementMatchers.next();
            safeTreeReporter.absentNode(Keys.elementKey(this.index++), r -> matcher.runForAbsentItem(safeTreeReporter));
        }
        if (this.index == 0) {
            safeTreeReporter.passedCheck("empty list");
        }
    }
}

