/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.checkers;

import com.github.alkedr.matchers.reporting.ReportingMatcher;
import com.github.alkedr.matchers.reporting.reporters.SafeTreeReporter;
import com.github.alkedr.matchers.reporting.sub.value.checkers.SubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;

class ContainsInAnyOrderSubValuesChecker<T>
implements SubValuesChecker {
    private final Collection<ReportingMatcher<? super T>> elementMatchers = new ArrayList<ReportingMatcher<? super T>>();
    private int index = 0;

    ContainsInAnyOrderSubValuesChecker(Iterable<? extends ReportingMatcher<? super T>> elementMatchers) {
        elementMatchers.forEach(this.elementMatchers::add);
    }

    @Override
    public void begin(SafeTreeReporter safeTreeReporter) {
    }

    @Override
    public Consumer<SafeTreeReporter> present(Key key, Object value) {
        ++this.index;
        Iterator<ReportingMatcher<T>> iterator = this.elementMatchers.iterator();
        while (iterator.hasNext()) {
            ReportingMatcher matcher = iterator.next();
            if (!matcher.matches(value)) continue;
            iterator.remove();
            return safeTreeReporter -> matcher.run(value, (SafeTreeReporter)safeTreeReporter);
        }
        return reporter -> {};
    }

    @Override
    public Consumer<SafeTreeReporter> absent(Key key) {
        ++this.index;
        return reporter -> {};
    }

    @Override
    public Consumer<SafeTreeReporter> broken(Key key, Throwable throwable) {
        ++this.index;
        return reporter -> {};
    }

    @Override
    public void end(SafeTreeReporter safeTreeReporter) {
        for (ReportingMatcher<? super T> reportingMatcher : this.elementMatchers) {
            safeTreeReporter.absentNode(Keys.elementKey(this.index++), r -> matcher.runForAbsentItem(safeTreeReporter));
        }
        if (this.index == 0) {
            safeTreeReporter.passedCheck("empty list");
        }
    }
}

