/*
 * Decompiled with CFR 0.152.
 */
package alex.mojaki.s3upload;

import alex.mojaki.s3upload.ConvertibleOutputStream;
import com.amazonaws.util.Base64;
import java.io.InputStream;

class StreamPart {
    private ConvertibleOutputStream stream;
    private int partNumber;
    static final StreamPart POISON = new StreamPart(null, -1);

    public StreamPart(ConvertibleOutputStream stream, int partNumber) {
        this.stream = stream;
        this.partNumber = partNumber;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public ConvertibleOutputStream getOutputStream() {
        return this.stream;
    }

    public InputStream getInputStream() {
        return this.stream.toInputStream();
    }

    public long size() {
        return this.stream.size();
    }

    public String getMD5Digest() {
        return Base64.encodeAsString((byte[])this.stream.getMD5Digest());
    }

    public String toString() {
        return String.format("[Part number %d %s]", this.partNumber, this.stream == null ? "with null stream" : String.format("containing %.2f MB", (double)this.size() / 1048576.0));
    }
}

