/*
 * Decompiled with CFR 0.152.
 */
package alex.mojaki.s3upload;

import alex.mojaki.s3upload.ConvertibleOutputStream;
import alex.mojaki.s3upload.StreamPart;
import alex.mojaki.s3upload.Utils;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(MultiPartOutputStream.class);
    private ConvertibleOutputStream currentStream;
    public static final int S3_MIN_PART_SIZE = 0x500000;
    private static final int STREAM_EXTRA_ROOM = 0x100000;
    private BlockingQueue<StreamPart> queue;
    private final int partNumberStart;
    private final int partNumberEnd;
    private final int partSize;
    private int currentPartNumber;

    MultiPartOutputStream(int partNumberStart, int partNumberEnd, int partSize, BlockingQueue<StreamPart> queue) {
        if (partNumberStart < 1) {
            throw new IndexOutOfBoundsException("The lowest allowed part number is 1. The value given was " + partNumberStart);
        }
        if (partNumberEnd > 10001) {
            throw new IndexOutOfBoundsException("The highest allowed part number is 10 000, so partNumberEnd must be at most 10 001. The value given was " + partNumberEnd);
        }
        if (partNumberEnd <= partNumberStart) {
            throw new IndexOutOfBoundsException(String.format("The part number end (%d) must be greater than the part number start (%d).", partNumberEnd, partNumberStart));
        }
        if (partSize < 0x500000) {
            throw new IllegalArgumentException(String.format("The given part size (%d) is less than 5 MB.", partSize));
        }
        this.partNumberStart = partNumberStart;
        this.partNumberEnd = partNumberEnd;
        this.queue = queue;
        this.partSize = partSize;
        log.debug("Creating {}", (Object)this);
        this.currentPartNumber = partNumberStart;
        this.currentStream = new ConvertibleOutputStream(this.getStreamAllocatedSize());
    }

    private int getStreamAllocatedSize() {
        return this.partSize + 0x500000 + 0x100000;
    }

    private void checkSize() {
        if (this.currentStream == null) {
            throw new IllegalStateException("The stream is closed and cannot be written to.");
        }
        if (this.currentStream.size() > this.partSize + 0x500000) {
            ConvertibleOutputStream newStream = this.currentStream.split(this.currentStream.size() - 0x500000, this.getStreamAllocatedSize());
            this.putCurrentStream();
            this.currentStream = newStream;
        }
    }

    private void putCurrentStream() {
        if (this.currentStream.size() == 0) {
            return;
        }
        if (this.currentPartNumber >= this.partNumberEnd) {
            throw new IndexOutOfBoundsException(String.format("This stream was allocated the part numbers from %d (inclusive) to %d (exclusive)and it has gone beyond the end.", this.partNumberStart, this.partNumberEnd));
        }
        StreamPart streamPart = new StreamPart(this.currentStream, this.currentPartNumber++);
        log.debug("Putting {} on queue", (Object)streamPart);
        try {
            this.queue.put(streamPart);
        }
        catch (InterruptedException e) {
            throw Utils.runtimeInterruptedException(e);
        }
    }

    @Override
    public void write(int b) {
        this.currentStream.write(b);
        this.checkSize();
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.currentStream.write(b, off, len);
        this.checkSize();
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
        this.checkSize();
    }

    @Override
    public void close() {
        log.info("Called close() on {}", (Object)this);
        if (this.currentStream == null) {
            log.warn("{} is already closed", (Object)this);
            return;
        }
        try {
            this.putCurrentStream();
            log.debug("Placing poison pill on queue for {}", (Object)this);
            this.queue.put(StreamPart.POISON);
        }
        catch (InterruptedException e) {
            log.error("Interrupted while closing {}", (Object)this);
            throw Utils.runtimeInterruptedException(e);
        }
        this.currentStream = null;
    }

    public String toString() {
        return String.format("[MultipartOutputStream for parts %d - %d]", this.partNumberStart, this.partNumberEnd - 1);
    }
}

