/*
 * Decompiled with CFR 0.152.
 */
package alex.mojaki.s3upload;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceResultsHandler<V>
implements Iterable<V> {
    private ExecutorCompletionService<V> completionService;
    private ExecutorService executorService;
    private AtomicInteger taskCount = new AtomicInteger(0);

    public ExecutorServiceResultsHandler(ExecutorService executorService) {
        this.executorService = executorService;
        this.completionService = new ExecutorCompletionService(executorService);
    }

    public void submit(Callable<V> task) {
        this.completionService.submit(task);
        this.taskCount.incrementAndGet();
    }

    public void finishedSubmitting() {
        this.executorService.shutdown();
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return ExecutorServiceResultsHandler.this.taskCount.getAndDecrement() > 0;
            }

            @Override
            public V next() {
                Exception exception;
                try {
                    return ExecutorServiceResultsHandler.this.completionService.take().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    exception = e;
                }
                catch (ExecutionException e) {
                    exception = e;
                }
                ExecutorServiceResultsHandler.this.abort();
                throw new RuntimeException(exception);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public void abort() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public void awaitCompletion() {
        for (V v : this) {
        }
    }
}

