/*
 * Decompiled with CFR 0.152.
 */
package alex.mojaki.s3upload;

import alex.mojaki.s3upload.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConvertibleOutputStream
extends ByteArrayOutputStream {
    private static final Logger log = LoggerFactory.getLogger(ConvertibleOutputStream.class);

    public ConvertibleOutputStream(int initialCapacity) {
        super(initialCapacity);
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

    public ConvertibleOutputStream split(int countToKeep, int initialCapacityForNewStream) {
        int newCount = this.count - countToKeep;
        log.debug("Splitting stream of size {} into parts with sizes {} and {}", new Object[]{this.count, countToKeep, newCount});
        initialCapacityForNewStream = Math.max(initialCapacityForNewStream, newCount);
        ConvertibleOutputStream newStream = new ConvertibleOutputStream(initialCapacityForNewStream);
        newStream.write(this.buf, countToKeep, newCount);
        this.count = countToKeep;
        return newStream;
    }

    public void append(ConvertibleOutputStream otherStream) {
        try {
            otherStream.writeTo(this);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] getMD5Digest() {
        MessageDigest md = Utils.md5();
        md.update(this.buf, 0, this.count);
        return md.digest();
    }
}

