/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.rendering.BorderType;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.table.Table;
import com.github.ajalt.mordant.table.TableKt;
import com.github.ajalt.mordant.table.TableRenderer;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B]\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000bH\u0002J$\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00032\u0006\u0010.\u001a\u00020\u000bH\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0002J\u0018\u00102\u001a\u0002032\u0006\u0010(\u001a\u00020)2\u0006\u00104\u001a\u00020\u000bH\u0016J \u00105\u001a\u0002032\u0006\u00100\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)2\u0006\u00104\u001a\u00020\u000bH\u0002J\u0018\u00106\u001a\u0002072\u0006\u0010(\u001a\u00020)2\u0006\u00104\u001a\u00020\u000bH\u0016R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00068"}, d2={"Lcom/github/ajalt/mordant/table/TableImpl;", "Lcom/github/ajalt/mordant/table/Table;", "rows", "", "Lcom/github/ajalt/mordant/table/Cell;", "Lcom/github/ajalt/mordant/table/ImmutableRow;", "borderType", "Lcom/github/ajalt/mordant/rendering/BorderType;", "borderStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "headerRowCount", "", "footerRowCount", "columnWidths", "Lcom/github/ajalt/mordant/table/ColumnWidth$Custom;", "tableBorders", "Lcom/github/ajalt/mordant/table/Borders;", "addPaddingWidthToFixedWidth", "", "(Ljava/util/List;Lcom/github/ajalt/mordant/rendering/BorderType;Lcom/github/ajalt/mordant/rendering/TextStyle;IILjava/util/List;Lcom/github/ajalt/mordant/table/Borders;Z)V", "getAddPaddingWidthToFixedWidth", "()Z", "getBorderStyle", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "getBorderType", "()Lcom/github/ajalt/mordant/rendering/BorderType;", "borderWidth", "columnBorders", "columnCount", "getColumnWidths", "()Ljava/util/List;", "expand", "getFooterRowCount", "()I", "getHeaderRowCount", "rowBorders", "getRows", "getTableBorders", "()Lcom/github/ajalt/mordant/table/Borders;", "calculateColumnWidths", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "terminalWidth", "distributeWidths", "weights", "", "totalWidth", "getCell", "x", "y", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "width", "measureColumn", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "mordant"})
@SourceDebugExtension(value={"SMAP\nTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Table.kt\ncom/github/ajalt/mordant/table/TableImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 WidthRange.kt\ncom/github/ajalt/mordant/rendering/WidthRangeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,458:1\n1#2:459\n1747#3,3:460\n1747#3,3:463\n1747#3,3:466\n1774#3,4:469\n1620#3,3:485\n1477#3:488\n1502#3,3:489\n1505#3,3:499\n1238#3,2:504\n1549#3:506\n1620#3,3:507\n1241#3:510\n1238#3,4:513\n1054#3:517\n1855#3:518\n766#3:519\n857#3,2:520\n1856#3:522\n1054#3:523\n1549#3:524\n1620#3,3:525\n1549#3:528\n1620#3,3:529\n1620#3,3:532\n27#4,12:473\n372#5,7:492\n453#5:502\n403#5:503\n453#5:511\n403#5:512\n*S KotlinDebug\n*F\n+ 1 Table.kt\ncom/github/ajalt/mordant/table/TableImpl\n*L\n85#1:460,3\n93#1:463,3\n104#1:466,3\n109#1:469,4\n167#1:485,3\n171#1:488\n171#1:489,3\n171#1:499,3\n172#1:504,2\n172#1:506\n172#1:507,3\n172#1:510\n175#1:513,4\n185#1:517\n185#1:518\n188#1:519\n188#1:520,2\n185#1:522\n199#1:523\n201#1:524\n201#1:525,3\n216#1:528\n216#1:529,3\n219#1:532,3\n147#1:473,12\n171#1:492,7\n172#1:502\n172#1:503\n175#1:511\n175#1:512\n*E\n"})
public final class TableImpl
extends Table {
    @NotNull
    private final List<List<Cell>> rows;
    @NotNull
    private final BorderType borderType;
    @NotNull
    private final TextStyle borderStyle;
    private final int headerRowCount;
    private final int footerRowCount;
    @NotNull
    private final List<ColumnWidth.Custom> columnWidths;
    @Nullable
    private final Borders tableBorders;
    private final boolean addPaddingWidthToFixedWidth;
    private final boolean expand;
    private final int columnCount;
    @NotNull
    private final List<Boolean> rowBorders;
    @NotNull
    private final List<Boolean> columnBorders;
    private final int borderWidth;

    /*
     * WARNING - void declaration
     */
    public TableImpl(@NotNull List<? extends List<? extends Cell>> rows, @NotNull BorderType borderType, @NotNull TextStyle borderStyle, int headerRowCount, int footerRowCount, @NotNull List<ColumnWidth.Custom> columnWidths, @Nullable Borders tableBorders, boolean addPaddingWidthToFixedWidth) {
        int n;
        void $this$count$iv;
        int element$iv;
        Iterator iterator;
        boolean $i$f$any;
        Iterable $this$any$iv;
        int n2;
        int n3;
        TableImpl tableImpl;
        block23: {
            void $this$any$iv22;
            Intrinsics.checkNotNullParameter(rows, (String)"rows");
            Intrinsics.checkNotNullParameter((Object)borderType, (String)"borderType");
            Intrinsics.checkNotNullParameter((Object)borderStyle, (String)"borderStyle");
            Intrinsics.checkNotNullParameter(columnWidths, (String)"columnWidths");
            super(null);
            this.rows = rows;
            this.borderType = borderType;
            this.borderStyle = borderStyle;
            this.headerRowCount = headerRowCount;
            this.footerRowCount = footerRowCount;
            this.columnWidths = columnWidths;
            this.tableBorders = tableBorders;
            this.addPaddingWidthToFixedWidth = addPaddingWidthToFixedWidth;
            if (!(!((Collection)this.rows).isEmpty())) {
                boolean $i$a$-require-TableImpl$22 = false;
                String $i$a$-require-TableImpl$22 = "Table cannot be empty";
                throw new IllegalArgumentException($i$a$-require-TableImpl$22.toString());
            }
            Iterable iterable = this.columnWidths;
            tableImpl = this;
            boolean $i$f$any2 = false;
            if ($this$any$iv22 instanceof Collection && ((Collection)$this$any$iv22).isEmpty()) {
                n3 = 0;
            } else {
                for (Object element$iv2 : $this$any$iv22) {
                    ColumnWidth.Custom it = (ColumnWidth.Custom)element$iv2;
                    boolean bl = false;
                    if (!(it.getExpandWeight() != null)) continue;
                    n3 = 1;
                    break block23;
                }
                n3 = 0;
            }
        }
        int n4 = n3;
        tableImpl.expand = n4;
        this.columnCount = this.columnWidths.size();
        int $this$any$iv22 = this.rows.size() + 1;
        tableImpl = this;
        ArrayList<Boolean> $i$f$any2 = new ArrayList<Boolean>($this$any$iv22);
        for (n2 = 0; n2 < $this$any$iv22; ++n2) {
            boolean bl;
            ArrayList<Boolean> arrayList;
            block24: {
                void y;
                int n5;
                int it = n5 = n2;
                arrayList = $i$f$any2;
                boolean bl2 = false;
                if (y == false && this.tableBorders != null) {
                    bl = this.tableBorders.getTop();
                } else if (y == this.rows.size() && this.tableBorders != null) {
                    bl = this.tableBorders.getBottom();
                } else {
                    $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.columnCount);
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            int x = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl3 = false;
                            if (!(TableKt.access$getT(this.getCell(x, (int)y)) || TableKt.access$getB(this.getCell(x, (int)(y - true))))) continue;
                            bl = true;
                            break block24;
                        }
                        bl = false;
                    }
                }
            }
            arrayList.add(bl);
        }
        tableImpl.rowBorders = $i$f$any2;
        $this$any$iv22 = this.columnCount + 1;
        tableImpl = this;
        $i$f$any2 = new ArrayList($this$any$iv22);
        for (n2 = 0; n2 < $this$any$iv22; ++n2) {
            boolean bl;
            ArrayList<Boolean> arrayList;
            block25: {
                void x;
                int n6;
                int y = n6 = n2;
                arrayList = $i$f$any2;
                boolean bl4 = false;
                if (x == false && this.tableBorders != null) {
                    bl = this.tableBorders.getLeft();
                } else if (x == this.columnCount && this.tableBorders != null) {
                    bl = this.tableBorders.getRight();
                } else {
                    $this$any$iv = (Iterable)CollectionsKt.getIndices((Collection)this.rows);
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            int y2 = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl5 = false;
                            if (!(TableKt.access$getL(this.getCell((int)x, y2)) || TableKt.access$getR(this.getCell((int)(x - true), y2)))) continue;
                            bl = true;
                            break block25;
                        }
                        bl = false;
                    }
                }
            }
            arrayList.add(bl);
        }
        tableImpl.columnBorders = $i$f$any2;
        Iterable $this$any$iv22 = this.columnBorders;
        tableImpl = this;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv3 : $this$count$iv) {
                boolean it = (Boolean)element$iv3;
                boolean bl = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        n4 = n;
        tableImpl.borderWidth = n4;
    }

    @NotNull
    public final List<List<Cell>> getRows() {
        return this.rows;
    }

    @NotNull
    public final BorderType getBorderType() {
        return this.borderType;
    }

    @NotNull
    public final TextStyle getBorderStyle() {
        return this.borderStyle;
    }

    public final int getHeaderRowCount() {
        return this.headerRowCount;
    }

    public final int getFooterRowCount() {
        return this.footerRowCount;
    }

    @NotNull
    public final List<ColumnWidth.Custom> getColumnWidths() {
        return this.columnWidths;
    }

    @Nullable
    public final Borders getTableBorders() {
        return this.tableBorders;
    }

    public final boolean getAddPaddingWidthToFixedWidth() {
        return this.addPaddingWidthToFixedWidth;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (this.expand) {
            return new WidthRange(width, width);
        }
        int remainingWidth = width - this.borderWidth;
        int n3 = this.columnCount;
        ArrayList<WidthRange> arrayList = new ArrayList<WidthRange>(n3);
        int n4 = 0;
        while (n4 < n3) {
            void it;
            int n5;
            int n6 = n5 = n4++;
            ArrayList<WidthRange> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.measureColumn((int)it, t, remainingWidth));
        }
        List ranges = arrayList;
        Iterable iterable = ranges;
        int n7 = 0;
        for (Object t2 : iterable) {
            WidthRange it = (WidthRange)t2;
            n2 = n7;
            boolean bl = false;
            n = it.getMin();
            n7 = n2 + n;
        }
        iterable = ranges;
        n2 = n7 + this.borderWidth;
        n7 = 0;
        for (Object t3 : iterable) {
            WidthRange it = (WidthRange)t3;
            n = n7;
            boolean bl = false;
            int n8 = it.getMax();
            n7 = n + n8;
        }
        n = n7;
        int n9 = n + this.borderWidth;
        int n10 = n2;
        return new WidthRange(n10, n9);
    }

    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new TableRenderer(this.rows, this.borderType, this.borderStyle, this.headerRowCount, this.footerRowCount, this.columnCount, this.calculateColumnWidths(t, width), this.columnBorders, this.rowBorders, this.tableBorders, t).render();
    }

    private final WidthRange measureColumn(int x, Terminal t, int width) {
        Integer n = this.columnWidths.get(x).getWidth();
        if (n != null) {
            int n2;
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (!this.addPaddingWidthToFixedWidth) {
                n2 = 0;
            } else {
                Object object;
                Iterator iterator = ((Iterable)this.rows).iterator();
                if (!iterator.hasNext()) {
                    object = null;
                } else {
                    Object row2 = (List)iterator.next();
                    boolean bl2 = false;
                    Object object2 = CollectionsKt.getOrNull((List)row2, (int)x);
                    Cell.Content content = object2 instanceof Cell.Content ? (Cell.Content)object2 : null;
                    row2 = content != null ? content.getPaddingWidth() : 0;
                    while (iterator.hasNext()) {
                        List row3 = (List)iterator.next();
                        $i$a$-maxOfOrNull-TableImpl$measureColumn$1$paddingWidth$1 = false;
                        Object object3 = CollectionsKt.getOrNull((List)row3, (int)x);
                        Cell.Content content2 = object3 instanceof Cell.Content ? (Cell.Content)object3 : null;
                        Comparable comparable = Integer.valueOf(content2 != null ? content2.getPaddingWidth() : 0);
                        if (row2.compareTo(comparable) >= 0) continue;
                        row2 = comparable;
                    }
                    object = row2;
                }
                Integer n3 = (Integer)object;
                n2 = n3 != null ? n3 : 0;
            }
            int paddingWidth = n2;
            return new WidthRange(it + paddingWidth, it + paddingWidth);
        }
        Iterable $this$maxWidthRange_u24default$iv = this.rows;
        int paddingWidth$iv = 0;
        boolean $i$f$maxWidthRange = false;
        int max$iv = 0;
        int min$iv = 0;
        for (Object it$iv : $this$maxWidthRange_u24default$iv) {
            WidthRange widthRange;
            List row4 = (List)it$iv;
            boolean bl = false;
            Cell cell2 = (Cell)CollectionsKt.getOrNull((List)row4, (int)x);
            if (cell2 == null) {
                widthRange = null;
            } else if (cell2 instanceof Cell.Empty) {
                widthRange = new WidthRange(0, 0);
            } else if (cell2 instanceof Cell.Content) {
                widthRange = ((Cell.Content)cell2).getContent().measure(t, width).div(((Cell.Content)cell2).getColumnSpan());
            } else if (cell2 instanceof Cell.SpanRef) {
                widthRange = ((Cell.SpanRef)cell2).getCell().getContent().measure(t, width).div(((Cell.SpanRef)cell2).getColumnSpan());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (widthRange == null) continue;
            WidthRange range$iv = widthRange;
            max$iv = Math.max(max$iv, range$iv.getMax());
            min$iv = Math.max(min$iv, range$iv.getMin());
        }
        WidthRange range = new WidthRange(min$iv + paddingWidth$iv, max$iv + paddingWidth$iv);
        if (this.columnWidths.get(x).getExpandWeight() != null) {
            return new WidthRange(range.getMin(), RangesKt.coerceAtLeast((int)width, (int)range.getMax()));
        }
        return range;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> calculateColumnWidths(Terminal t, int terminalWidth) {
        void $this$forEach$iv;
        void $this$mapValuesTo$iv$iv;
        Map shrinkPriorities;
        Object object;
        int $i$f$mapTo;
        Object k;
        void $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable destination$iv;
        void $this$mapTo$iv;
        Object object2;
        int availableWidth = terminalWidth - this.borderWidth;
        if (availableWidth <= 0) {
            int n = this.columnCount;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Integer> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(0);
            }
            return arrayList;
        }
        int n = this.columnCount;
        Iterable<Object> iterable = new ArrayList<Object>(n);
        int n5 = 0;
        while (n5 < n) {
            void it;
            int it2;
            int bl = it2 = n5++;
            object2 = iterable;
            boolean bl2 = false;
            ((ArrayList)object2).add(this.measureColumn((int)it, t, availableWidth));
        }
        List measurements = iterable;
        iterable = measurements;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            WidthRange widthRange = (WidthRange)item$iv;
            object2 = destination$iv;
            boolean bl = false;
            object2.add(it.getMax());
        }
        List widths = (List)destination$iv;
        destination$iv = CollectionsKt.withIndex((Iterable)this.columnWidths);
        boolean $i$f$groupBy = false;
        Iterator it = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            IndexedValue it3 = (IndexedValue)element$iv$iv;
            boolean bl = false;
            key$iv$iv = ((ColumnWidth.Custom)it3.getValue()).getPriority();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void entry;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv3 = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = $this$getOrPut$iv$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)entry.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = 0;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                collection2.add(it4.getIndex());
            }
            object = (List)destination$iv$iv2;
            object2.put(k, object);
        }
        Map $this$mapValues$iv2 = shrinkPriorities = destination$iv$iv;
        boolean $i$f$mapValues2 = false;
        destination$iv$iv = $this$mapValues$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            int n6;
            int n7;
            int it4;
            void entry;
            void it$iv$iv;
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv3 = destination$iv$iv3;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv3;
            boolean bl5 = false;
            Iterable $i$f$map = (Iterable)entry.getValue();
            $i$f$mapTo = 0;
            for (Object t2 : $i$f$map) {
                it4 = ((Number)t2).intValue();
                n7 = $i$f$mapTo;
                boolean bl6 = false;
                n6 = ((WidthRange)measurements.get(it4)).getMin();
                $i$f$mapTo = n7 + n6;
            }
            $i$f$map = (Iterable)entry.getValue();
            n7 = $i$f$mapTo;
            $i$f$mapTo = 0;
            for (Object t2 : $i$f$map) {
                it4 = ((Number)t2).intValue();
                n6 = $i$f$mapTo;
                boolean bl7 = false;
                int n8 = ((WidthRange)measurements.get(it4)).getMax();
                $i$f$mapTo = n6 + n8;
            }
            int n9 = n6 = $i$f$mapTo;
            int n10 = n7;
            object = new WidthRange(n10, n9);
            object2.put(k, object);
        }
        Map priorityMeasurements = destination$iv$iv3;
        int remainingWidth = 0;
        remainingWidth = availableWidth;
        Map allocatedWidths = new LinkedHashMap();
        Iterable $this$sortedByDescending$iv = priorityMeasurements.entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object42;
            Integer $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map.Entry $i$f$associateByTo22 = (Map.Entry)element$iv;
            boolean bl = false;
            int p = ((Number)$i$f$associateByTo22.getKey()).intValue();
            WidthRange m = (WidthRange)$i$f$associateByTo22.getValue();
            Iterable $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv3 = priorityMeasurements.entrySet();
            int $i$f$filter = 0;
            void entry = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator $this$mapTo$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object element$iv$iv = $this$mapTo$iv$iv.next();
                Map.Entry it5 = (Map.Entry)element$iv$iv;
                boolean bl8 = false;
                if (!(((Number)it5.getKey()).intValue() < p)) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv4;
            $i$f$filter = 0;
            for (Object object42 : $this$filter$iv) {
                void it6;
                Map.Entry $i$f$filterTo2 = (Map.Entry)object42;
                int n11 = $i$f$filter;
                boolean bl9 = false;
                int n12 = ((WidthRange)it6.getValue()).getMin();
                $i$f$filter = n11 + n12;
            }
            int lowerMin = $i$f$filter;
            int allocated = RangesKt.coerceAtMost((int)RangesKt.coerceIn((int)(remainingWidth - lowerMin), (int)m.getMin(), (int)m.getMax()), (int)remainingWidth);
            remainingWidth -= allocated;
            $this$filterTo$iv$iv = p;
            object42 = allocated;
            allocatedWidths.put($this$filterTo$iv$iv, object42);
        }
        Iterable $this$sortedByDescending$iv2 = allocatedWidths.entrySet();
        boolean $i$f$sortedByDescending2 = false;
        for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
            }
        })) {
            void $this$mapTo$iv$iv;
            int p = ((Number)entry.getKey()).intValue();
            int w = ((Number)entry.getValue()).intValue();
            Object v = shrinkPriorities.get(p);
            Intrinsics.checkNotNull(v);
            List indexes = (List)v;
            Iterable $this$map$iv = indexes;
            boolean $i$f$map = false;
            Iterable allocated = $this$map$iv;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void i;
                int bl9 = ((Number)item$iv$iv).intValue();
                object2 = destination$iv$iv5;
                boolean bl = false;
                Float f = this.columnWidths.get((int)i).getExpandWeight();
                object2.add(Float.valueOf(f != null ? f.floatValue() : (float)((WidthRange)measurements.get((int)i)).getMax()));
            }
            List weights = (List)destination$iv$iv5;
            List<Integer> distributedWidths = this.distributeWidths(weights, w);
            for (Pair pair : CollectionsKt.zip((Iterable)indexes, (Iterable)distributedWidths)) {
                int i = ((Number)pair.component1()).intValue();
                int ww = ((Number)pair.component2()).intValue();
                widths.set(i, ww);
            }
        }
        return widths;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> distributeWidths(List<Float> weights, int totalWidth) {
        void destination$iv;
        void $this$mapTo$iv;
        if (totalWidth == 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = weights;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv22;
                boolean bl = false;
                collection.add(0);
            }
            return (List)destination$iv$iv22;
        }
        Iterable $this$mapTo$iv$iv = weights;
        double destination$iv$iv22 = 0.0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            float it = ((Number)item$iv$iv).floatValue();
            double d = destination$iv$iv22;
            boolean bl = false;
            double d2 = it;
            destination$iv$iv22 = d + d2;
        }
        double totalWeight = destination$iv$iv22;
        Iterable destination$iv$iv22 = weights;
        Collection $i$f$mapTo = new ArrayList();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void weight;
            float bl = ((Number)item$iv).floatValue();
            void var13_29 = destination$iv;
            boolean bl2 = false;
            var13_29.add((int)((double)weight / totalWeight * (double)totalWidth));
        }
        List widths = (List)destination$iv;
        int n = totalWidth - CollectionsKt.sumOfInt((Iterable)widths);
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            boolean bl = false;
            widths.set(i, ((Number)widths.get(i)).intValue() + 1);
        }
        return widths;
    }

    private final Cell getCell(int x, int y) {
        List list = (List)CollectionsKt.getOrNull(this.rows, (int)y);
        return list != null ? (Cell)CollectionsKt.getOrNull((List)list, (int)x) : null;
    }
}

