/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal.jna;

import com.github.ajalt.mordant.internal.MppImpls;
import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.internal.jna.WinKernel32Lib;
import com.oracle.svm.core.annotate.Delete;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Delete
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/ajalt/mordant/internal/jna/JnaWin32MppImpls;", "Lcom/github/ajalt/mordant/internal/MppImpls;", "()V", "kernel", "Lcom/github/ajalt/mordant/internal/jna/WinKernel32Lib;", "kotlin.jvm.PlatformType", "stderrHandle", "Lcom/github/ajalt/mordant/internal/jna/WinKernel32Lib$HANDLE;", "stdinHandle", "stdoutHandle", "getTerminalSize", "Lcom/github/ajalt/mordant/internal/Size;", "stderrInteractive", "", "stdinInteractive", "stdoutInteractive", "mordant"})
@SourceDebugExtension(value={"SMAP\nJnaWin32MppImpls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JnaWin32MppImpls.kt\ncom/github/ajalt/mordant/internal/jna/JnaWin32MppImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class JnaWin32MppImpls
implements MppImpls {
    private final WinKernel32Lib kernel = (WinKernel32Lib)Native.load((String)"kernel32", WinKernel32Lib.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    @NotNull
    private final WinKernel32Lib.HANDLE stdoutHandle = this.kernel.GetStdHandle(-11);
    @NotNull
    private final WinKernel32Lib.HANDLE stdinHandle = this.kernel.GetStdHandle(-10);
    @NotNull
    private final WinKernel32Lib.HANDLE stderrHandle = this.kernel.GetStdHandle(-12);

    @Override
    public boolean stdoutInteractive() {
        return this.kernel.GetConsoleMode(this.stdoutHandle, new IntByReference());
    }

    @Override
    public boolean stdinInteractive() {
        return this.kernel.GetConsoleMode(this.stdinHandle, new IntByReference());
    }

    @Override
    public boolean stderrInteractive() {
        return this.kernel.GetConsoleMode(this.stderrHandle, new IntByReference());
    }

    @Override
    @Nullable
    public Size getTerminalSize() {
        Size size;
        WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO csbi = new WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO();
        if (!this.kernel.GetConsoleScreenBufferInfo(this.stdoutHandle, csbi)) {
            return null;
        }
        WinKernel32Lib.SMALL_RECT sMALL_RECT = csbi.srWindow;
        if (sMALL_RECT != null) {
            WinKernel32Lib.SMALL_RECT $this$getTerminalSize_u24lambda_u240 = sMALL_RECT;
            boolean bl = false;
            size = new Size($this$getTerminalSize_u24lambda_u240.Right - $this$getTerminalSize_u24lambda_u240.Left + 1, $this$getTerminalSize_u24lambda_u240.Bottom - $this$getTerminalSize_u24lambda_u240.Top + 1);
        } else {
            size = null;
        }
        return size;
    }

    @Override
    public boolean fastIsTty() {
        return MppImpls.DefaultImpls.fastIsTty(this);
    }
}

