/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.mordant.internal.FallbackMppImpls;
import com.github.ajalt.mordant.internal.JvmAtomicInt;
import com.github.ajalt.mordant.internal.JvmAtomicRef;
import com.github.ajalt.mordant.internal.JvmTerminalCursor;
import com.github.ajalt.mordant.internal.MppAtomicInt;
import com.github.ajalt.mordant.internal.MppAtomicRef;
import com.github.ajalt.mordant.internal.MppImpls;
import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.internal.jna.JnaLinuxMppImpls;
import com.github.ajalt.mordant.internal.jna.JnaMacosMppImpls;
import com.github.ajalt.mordant.internal.jna.JnaWin32MppImpls;
import com.github.ajalt.mordant.internal.nativeimage.NativeImagePosixMppImpls;
import com.github.ajalt.mordant.internal.nativeimage.NativeImageWin32MppImpls;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import java.io.Console;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ConsoleKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a!\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u0002H\u0010H\u0000\u00a2\u0006\u0002\u0010\u0012\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0000\u001a\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0001H\u0000\u001a\u0012\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u0001H\u0000\u001a\b\u0010%\u001a\u00020\u0001H\u0000\u001a&\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0000\u001a\b\u0010.\u001a\u00020\u0001H\u0000\u001a\b\u0010/\u001a\u00020\u0001H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"CR_IMPLIES_LF", "", "getCR_IMPLIES_LF", "()Z", "FAST_ISATTY", "getFAST_ISATTY", "impls", "Lcom/github/ajalt/mordant/internal/MppImpls;", "printRequestLock", "", "MppAtomicInt", "Lcom/github/ajalt/mordant/internal/MppAtomicInt;", "initial", "", "MppAtomicRef", "Lcom/github/ajalt/mordant/internal/MppAtomicRef;", "T", "value", "(Ljava/lang/Object;)Lcom/github/ajalt/mordant/internal/MppAtomicRef;", "codepointSequence", "Lkotlin/sequences/Sequence;", "string", "", "getEnv", "key", "getTerminalSize", "Lcom/github/ajalt/mordant/internal/Size;", "makePrintingTerminalCursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "printStderr", "", "message", "newline", "readLineOrNullMpp", "hideInput", "runningInIdeaJavaAgent", "sendInterceptedPrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "terminalInterface", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "interceptors", "", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "stdinInteractive", "stdoutInteractive", "mordant"})
@SourceDebugExtension(value={"SMAP\nMppImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MppImpl.kt\ncom/github/ajalt/mordant/internal/MppImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1747#2,3:145\n1789#2,3:148\n*S KotlinDebug\n*F\n+ 1 MppImpl.kt\ncom/github/ajalt/mordant/internal/MppImplKt\n*L\n51#1:145,3\n116#1:148,3\n*E\n"})
public final class MppImplKt {
    @NotNull
    private static final Object printRequestLock = new Object();
    @NotNull
    private static final MppImpls impls;
    private static final boolean FAST_ISATTY;
    private static final boolean CR_IMPLIES_LF;

    @NotNull
    public static final MppAtomicInt MppAtomicInt(int initial) {
        return new JvmAtomicInt(initial);
    }

    @NotNull
    public static final <T> MppAtomicRef<T> MppAtomicRef(T value) {
        return new JvmAtomicRef<T>(value);
    }

    @Nullable
    public static final String getEnv(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return System.getenv(key);
    }

    public static final boolean runningInIdeaJavaAgent() {
        boolean bl;
        try {
            boolean bl2;
            block5: {
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                List<String> jvmArgs = bean.getInputArguments();
                Intrinsics.checkNotNull(jvmArgs);
                Iterable $this$any$iv = jvmArgs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!(StringsKt.startsWith$default((String)it, (String)"-javaagent", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"idea_rt.jar", (boolean)false, (int)2, null))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (SecurityException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final Sequence<Integer> codepointSequence(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        PrimitiveIterator.OfInt ofInt = string.codePoints().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)ofInt, (String)"iterator(...)");
        return SequencesKt.asSequence((Iterator)ofInt);
    }

    public static final void printStderr(@NotNull String message, boolean newline) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (newline) {
            System.err.println(message);
        } else {
            System.err.print(message);
        }
    }

    @Nullable
    public static final String readLineOrNullMpp(boolean hideInput) {
        Console console;
        if (hideInput && (console = System.console()) != null) {
            char[] cArray = console.readPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"readPassword(...)");
            return StringsKt.concatToString((char[])cArray);
        }
        return ConsoleKt.readlnOrNull();
    }

    @NotNull
    public static final TerminalCursor makePrintingTerminalCursor(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        return new JvmTerminalCursor(terminal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void sendInterceptedPrintRequest(@NotNull PrintRequest request, @NotNull TerminalInterface terminalInterface, @NotNull List<? extends TerminalInterceptor> interceptors) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)terminalInterface, (String)"terminalInterface");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        Object object = printRequestLock;
        synchronized (object) {
            void $this$fold$iv;
            boolean bl = false;
            Iterable iterable = interceptors;
            TerminalInterface terminalInterface2 = terminalInterface;
            boolean $i$f$fold = false;
            PrintRequest accumulator$iv = request;
            for (Object element$iv : $this$fold$iv) {
                void it;
                TerminalInterceptor terminalInterceptor = (TerminalInterceptor)element$iv;
                PrintRequest acc = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = it.intercept(acc);
            }
            terminalInterface2.completePrintRequest(accumulator$iv);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final boolean stdoutInteractive() {
        return impls.stdoutInteractive();
    }

    public static final boolean stdinInteractive() {
        return impls.stdinInteractive();
    }

    @Nullable
    public static final Size getTerminalSize() {
        return impls.getTerminalSize();
    }

    public static final boolean getFAST_ISATTY() {
        return FAST_ISATTY;
    }

    public static final boolean getCR_IMPLIES_LF() {
        return CR_IMPLIES_LF;
    }

    /*
     * Unable to fully structure code
     */
    static {
        os = System.getProperty("os.name");
        $i$a$-let-MppImplKt$impls$1 = false;
        try {
            imageCode = System.getProperty("org.graalvm.nativeimage.imagecode");
            isNativeImage = Intrinsics.areEqual((Object)imageCode, (Object)"buildtime") != false || Intrinsics.areEqual((Object)imageCode, (Object)"runtime") != false;
            if (!isNativeImage) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)os);
            if (StringsKt.startsWith$default((String)os, (String)"Windows", (boolean)false, (int)2, null)) {
                v0 = new NativeImageWin32MppImpls();
            } else if (isNativeImage && (Intrinsics.areEqual((Object)os, (Object)"Linux") || Intrinsics.areEqual((Object)os, (Object)"Mac OS X"))) {
                v0 = new NativeImagePosixMppImpls();
            } else {
                Intrinsics.checkNotNull((Object)os);
                v0 = StringsKt.startsWith$default((String)os, (String)"Windows", (boolean)false, (int)2, null) != false ? (MppImpls)new JnaWin32MppImpls() : (Intrinsics.areEqual((Object)os, (Object)"Linux") != false ? (MppImpls)new JnaLinuxMppImpls() : (Intrinsics.areEqual((Object)os, (Object)"Mac OS X") != false ? (MppImpls)new JnaMacosMppImpls() : (MppImpls)new FallbackMppImpls()));
            }
            var2_2 = v0;
        }
        catch (UnsatisfiedLinkError e) {
            var2_2 = new FallbackMppImpls();
        }
        MppImplKt.impls = var2_2;
        MppImplKt.FAST_ISATTY = true;
    }
}

