/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.animation;

import com.github.ajalt.mordant.internal.MppAtomicRef;
import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.terminal.CursorMovements;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.widgets.EmptyWidget;
import java.util.ConcurrentModificationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001)B\u0017\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002JJ\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u0010 \u001a\u00020!H\u0002J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020\u0012J\u0013\u0010'\u001a\u00020\u00122\u0006\u0010$\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/github/ajalt/mordant/animation/Animation;", "T", "", "trailingLinebreak", "", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "(ZLcom/github/ajalt/mordant/terminal/Terminal;)V", "interceptor", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "state", "Lcom/github/ajalt/mordant/internal/MppAtomicRef;", "Lcom/github/ajalt/mordant/animation/Animation$State;", "getTerminal", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "getTrailingLinebreak$annotations", "()V", "clear", "", "doStop", "Lkotlin/Pair;", "clearSize", "newline", "getCursorMoves", "", "firstDraw", "clearScreen", "lastSize", "Lcom/github/ajalt/mordant/internal/Size;", "size", "terminalSize", "lastTerminalSize", "extraUp", "", "renderData", "Lcom/github/ajalt/mordant/rendering/Widget;", "data", "(Ljava/lang/Object;)Lcom/github/ajalt/mordant/rendering/Widget;", "stop", "update", "(Ljava/lang/Object;)V", "State", "mordant"})
@SourceDebugExtension(value={"SMAP\nAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animation.kt\ncom/github/ajalt/mordant/animation/Animation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MppH.kt\ncom/github/ajalt/mordant/internal/MppHKt\n*L\n1#1,241:1\n1#2:242\n18#3,7:243\n18#3,7:250\n18#3,7:257\n*S KotlinDebug\n*F\n+ 1 Animation.kt\ncom/github/ajalt/mordant/animation/Animation\n*L\n123#1:243,7\n150#1:250,7\n55#1:257,7\n*E\n"})
public abstract class Animation<T> {
    private final boolean trailingLinebreak;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final MppAtomicRef<State> state;
    @NotNull
    private final TerminalInterceptor interceptor;

    public Animation(boolean trailingLinebreak, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.trailingLinebreak = trailingLinebreak;
        this.terminal = terminal;
        this.state = MppImplKt.MppAtomicRef(new State(null, null, null, null, false, false, 63, null));
        this.interceptor = arg_0 -> Animation.interceptor$lambda$3(this, arg_0);
    }

    public /* synthetic */ Animation(boolean bl, Terminal terminal, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl, terminal);
    }

    @Deprecated(message="This parameter is ignored; animations never print a trailing linebreak.")
    private static /* synthetic */ void getTrailingLinebreak$annotations() {
    }

    @NotNull
    public final Terminal getTerminal() {
        return this.terminal;
    }

    @NotNull
    protected abstract Widget renderData(T var1);

    public final void clear() {
        block0: {
            State old = (State)this.doStop(true, false).component1();
            String string = this.getCursorMoves(false, true, old.getSize(), null, new Size(this.terminal.getInfo().getWidth(), this.terminal.getInfo().getHeight()), old.getLastTerminalSize(), old.getFirstDraw() && old.getSize() != null ? 1 : 0);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Terminal.rawPrint$default(this.terminal, it, false, 2, null);
        }
    }

    public final void stop() {
        this.doStop(false, true);
    }

    private final Pair<State, State> doStop(boolean clearSize, boolean newline) {
        State newValue$iv;
        State old$iv;
        block4: {
            MppAtomicRef<State> $this$update_u24default$iv = this.state;
            int attempts$iv = 99;
            boolean $i$f$update = false;
            for (int i = 0; i < attempts$iv; ++i) {
                int it$iv = i;
                boolean bl = false;
                State $this$doStop_u24lambda_u245 = old$iv = $this$update_u24default$iv.getValue();
                boolean bl2 = false;
                Size size = clearSize ? null : $this$doStop_u24lambda_u245.getSize();
                newValue$iv = State.copy$default($this$doStop_u24lambda_u245, size, null, null, null, false, true, 6, null);
                if (!$this$update_u24default$iv.compareAndSet(old$iv, newValue$iv)) {
                    continue;
                }
                break block4;
            }
            throw new ConcurrentModificationException("Failed to update state due to concurrent updates");
        }
        Pair pair = TuplesKt.to((Object)old$iv, (Object)newValue$iv);
        State old = (State)pair.component1();
        State state = (State)pair.component2();
        if (old.getInterceptorInstalled()) {
            this.terminal.removeInterceptor$mordant(this.interceptor);
            if (newline) {
                Terminal.println$default(this.terminal, false, 1, null);
            }
        }
        return TuplesKt.to((Object)old, (Object)state);
    }

    public final void update(T data) {
        State newValue$iv;
        State old$iv;
        block4: {
            if (MppImplKt.getFAST_ISATTY()) {
                this.terminal.getInfo().updateTerminalSize();
            }
            Lines rendered = Widget.DefaultImpls.render$default(this.renderData(data), this.terminal, 0, 2, null);
            int height = rendered.getHeight();
            int width = rendered.getWidth();
            MppAtomicRef<State> $this$update_u24default$iv = this.state;
            int attempts$iv = 99;
            boolean $i$f$update = false;
            int n = 0;
            while (n < attempts$iv) {
                String string;
                int it$iv = n++;
                boolean bl = false;
                State $this$update_u24lambda_u246 = old$iv = $this$update_u24default$iv.getValue();
                boolean bl2 = false;
                Size size = new Size(width, height);
                Size size2 = $this$update_u24lambda_u246.getSize();
                newValue$iv = State.copy$default($this$update_u24lambda_u246, size, size2, null, string = Terminal.render$default(this.terminal, rendered, null, null, null, null, 30, null), true, false, 36, null);
                if (!$this$update_u24default$iv.compareAndSet(old$iv, newValue$iv)) {
                    continue;
                }
                break block4;
            }
            throw new ConcurrentModificationException("Failed to update state due to concurrent updates");
        }
        State old = (State)TuplesKt.to((Object)old$iv, (Object)newValue$iv).component1();
        if (!old.getInterceptorInstalled() && this.terminal.getInfo().getOutputInteractive()) {
            this.terminal.addInterceptor$mordant(this.interceptor);
        }
        Terminal.print$default(this.terminal, EmptyWidget.INSTANCE, false, 2, null);
    }

    private final String getCursorMoves(boolean firstDraw, boolean clearScreen, Size lastSize, Size size, Size terminalSize, Size lastTerminalSize, int extraUp) {
        if (firstDraw || lastSize == null) {
            return null;
        }
        return this.terminal.getCursor().getMoves((Function1<? super CursorMovements, Unit>)((Function1)new Function1<CursorMovements, Unit>(this, lastTerminalSize, terminalSize, lastSize, size, extraUp, clearScreen){
            final /* synthetic */ Animation<T> this$0;
            final /* synthetic */ Size $lastTerminalSize;
            final /* synthetic */ Size $terminalSize;
            final /* synthetic */ Size $lastSize;
            final /* synthetic */ Size $size;
            final /* synthetic */ int $extraUp;
            final /* synthetic */ boolean $clearScreen;
            {
                this.this$0 = $receiver;
                this.$lastTerminalSize = $lastTerminalSize;
                this.$terminalSize = $terminalSize;
                this.$lastSize = $lastSize;
                this.$size = $size;
                this.$extraUp = $extraUp;
                this.$clearScreen = $clearScreen;
                super(1);
            }

            public final void invoke(@NotNull CursorMovements $this$getMoves) {
                Intrinsics.checkNotNullParameter((Object)$this$getMoves, (String)"$this$getMoves");
                $this$getMoves.startOfLine();
                if (MppImplKt.getCR_IMPLIES_LF()) {
                    $this$getMoves.up(1);
                }
                if (this.this$0.getTerminal().getInfo().getCrClearsLine()) {
                    return;
                }
                boolean terminalShrank = this.$lastTerminalSize != null && this.$terminalSize.getWidth() < this.$lastTerminalSize.getWidth() && this.$terminalSize.getWidth() < this.$lastSize.getWidth();
                boolean widgetShrank = this.$size != null && (this.$size.getWidth() < this.$lastSize.getWidth() || this.$size.getHeight() < this.$lastSize.getHeight());
                int up = terminalShrank ? this.$lastSize.getHeight() * (int)((double)this.$lastSize.getWidth() / (double)this.$terminalSize.getWidth()) : RangesKt.coerceAtLeast((int)(this.$lastSize.getHeight() - 1), (int)0);
                $this$getMoves.up(up + this.$extraUp);
                if (terminalShrank || widgetShrank || this.$clearScreen) {
                    $this$getMoves.clearScreenAfterCursor();
                }
            }
        }));
    }

    static /* synthetic */ String getCursorMoves$default(Animation animation2, boolean bl, boolean bl2, Size size, Size size2, Size size3, Size size4, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCursorMoves");
        }
        if ((n2 & 0x40) != 0) {
            n = 0;
        }
        return animation2.getCursorMoves(bl, bl2, size, size2, size3, size4, n);
    }

    private static final PrintRequest interceptor$lambda$3(Animation this$0, PrintRequest req) {
        StringBuilder stringBuilder;
        State newValue$iv;
        State old$iv;
        Size terminalSize;
        block7: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            terminalSize = new Size(this$0.terminal.getInfo().getWidth(), this$0.terminal.getInfo().getHeight());
            MppAtomicRef<State> $this$update_u24default$iv = this$0.state;
            int attempts$iv = 99;
            boolean $i$f$update = false;
            int n = 0;
            while (n < attempts$iv) {
                int it$iv = n++;
                boolean bl = false;
                State $this$interceptor_u24lambda_u243_u24lambda_u240 = old$iv = $this$update_u24default$iv.getValue();
                boolean bl2 = false;
                Size size = $this$interceptor_u24lambda_u243_u24lambda_u240.getSize();
                newValue$iv = State.copy$default($this$interceptor_u24lambda_u243_u24lambda_u240, null, size, terminalSize, null, false, false, 25, null);
                if (!$this$update_u24default$iv.compareAndSet(old$iv, newValue$iv)) {
                    continue;
                }
                break block7;
            }
            throw new ConcurrentModificationException("Failed to update state due to concurrent updates");
        }
        State st = (State)TuplesKt.to((Object)old$iv, (Object)newValue$iv).component1();
        String string = st.getText();
        if (string == null) {
            return req;
        }
        String animationText = string;
        StringBuilder $this$interceptor_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string2 = this$0.getCursorMoves(st.getFirstDraw(), ((CharSequence)req.getText()).length() > 0, st.getLastSize(), st.getSize(), terminalSize, st.getLastTerminalSize(), StringsKt.startsWith$default((String)req.getText(), (String)"\r", (boolean)false, (int)2, null) ? 1 : 0);
        if (string2 != null) {
            String it = string2;
            boolean bl3 = false;
            $this$interceptor_u24lambda_u243_u24lambda_u242.append(it);
        }
        if (StringsKt.endsWith$default((String)req.getText(), (String)"\n", (boolean)false, (int)2, null)) {
            $this$interceptor_u24lambda_u243_u24lambda_u242.append(req.getText());
        } else if (((CharSequence)req.getText()).length() > 0) {
            StringBuilder stringBuilder2 = $this$interceptor_u24lambda_u243_u24lambda_u242.append(req.getText());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        }
        $this$interceptor_u24lambda_u243_u24lambda_u242.append(animationText);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String newText = string3;
        return new PrintRequest(newText, false, req.getStderr());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BI\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003JM\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/github/ajalt/mordant/animation/Animation$State;", "", "size", "Lcom/github/ajalt/mordant/internal/Size;", "lastSize", "lastTerminalSize", "text", "", "interceptorInstalled", "", "firstDraw", "(Lcom/github/ajalt/mordant/internal/Size;Lcom/github/ajalt/mordant/internal/Size;Lcom/github/ajalt/mordant/internal/Size;Ljava/lang/String;ZZ)V", "getFirstDraw", "()Z", "getInterceptorInstalled", "getLastSize", "()Lcom/github/ajalt/mordant/internal/Size;", "getLastTerminalSize", "getSize", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "mordant"})
    private static final class State {
        @Nullable
        private final Size size;
        @Nullable
        private final Size lastSize;
        @Nullable
        private final Size lastTerminalSize;
        @Nullable
        private final String text;
        private final boolean interceptorInstalled;
        private final boolean firstDraw;

        public State(@Nullable Size size, @Nullable Size lastSize, @Nullable Size lastTerminalSize, @Nullable String text2, boolean interceptorInstalled, boolean firstDraw) {
            this.size = size;
            this.lastSize = lastSize;
            this.lastTerminalSize = lastTerminalSize;
            this.text = text2;
            this.interceptorInstalled = interceptorInstalled;
            this.firstDraw = firstDraw;
        }

        public /* synthetic */ State(Size size, Size size2, Size size3, String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                size = null;
            }
            if ((n & 2) != 0) {
                size2 = null;
            }
            if ((n & 4) != 0) {
                size3 = null;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            this(size, size2, size3, string, bl, bl2);
        }

        @Nullable
        public final Size getSize() {
            return this.size;
        }

        @Nullable
        public final Size getLastSize() {
            return this.lastSize;
        }

        @Nullable
        public final Size getLastTerminalSize() {
            return this.lastTerminalSize;
        }

        @Nullable
        public final String getText() {
            return this.text;
        }

        public final boolean getInterceptorInstalled() {
            return this.interceptorInstalled;
        }

        public final boolean getFirstDraw() {
            return this.firstDraw;
        }

        @Nullable
        public final Size component1() {
            return this.size;
        }

        @Nullable
        public final Size component2() {
            return this.lastSize;
        }

        @Nullable
        public final Size component3() {
            return this.lastTerminalSize;
        }

        @Nullable
        public final String component4() {
            return this.text;
        }

        public final boolean component5() {
            return this.interceptorInstalled;
        }

        public final boolean component6() {
            return this.firstDraw;
        }

        @NotNull
        public final State copy(@Nullable Size size, @Nullable Size lastSize, @Nullable Size lastTerminalSize, @Nullable String text2, boolean interceptorInstalled, boolean firstDraw) {
            return new State(size, lastSize, lastTerminalSize, text2, interceptorInstalled, firstDraw);
        }

        public static /* synthetic */ State copy$default(State state, Size size, Size size2, Size size3, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                size = state.size;
            }
            if ((n & 2) != 0) {
                size2 = state.lastSize;
            }
            if ((n & 4) != 0) {
                size3 = state.lastTerminalSize;
            }
            if ((n & 8) != 0) {
                string = state.text;
            }
            if ((n & 0x10) != 0) {
                bl = state.interceptorInstalled;
            }
            if ((n & 0x20) != 0) {
                bl2 = state.firstDraw;
            }
            return state.copy(size, size2, size3, string, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "State(size=" + this.size + ", lastSize=" + this.lastSize + ", lastTerminalSize=" + this.lastTerminalSize + ", text=" + this.text + ", interceptorInstalled=" + this.interceptorInstalled + ", firstDraw=" + this.firstDraw + ')';
        }

        public int hashCode() {
            int result = this.size == null ? 0 : this.size.hashCode();
            result = result * 31 + (this.lastSize == null ? 0 : this.lastSize.hashCode());
            result = result * 31 + (this.lastTerminalSize == null ? 0 : this.lastTerminalSize.hashCode());
            result = result * 31 + (this.text == null ? 0 : this.text.hashCode());
            result = result * 31 + Boolean.hashCode(this.interceptorInstalled);
            result = result * 31 + Boolean.hashCode(this.firstDraw);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual((Object)this.size, (Object)state.size)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastSize, (Object)state.lastSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastTerminalSize, (Object)state.lastTerminalSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)state.text)) {
                return false;
            }
            if (this.interceptorInstalled != state.interceptorInstalled) {
                return false;
            }
            return this.firstDraw == state.firstDraw;
        }

        public State() {
            this(null, null, null, null, false, false, 63, null);
        }
    }
}

