/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.validator;

import com.joe.utils.validator.ValidationException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;

public class ValidatorUtil {
    private static final Validator validator;
    private static final ExecutableValidator executableValidator;

    public static void validate(Object bean) {
        Set constraintViolations = validator.validate(bean, new Class[0]);
        ValidatorUtil.check(constraintViolations);
    }

    public static void validateParameters(Object instance, Method method, Object[] params) {
        Set constraintViolations = executableValidator.validateParameters(instance, method, params, new Class[0]);
        ValidatorUtil.check(constraintViolations);
    }

    private static void check(Set<ConstraintViolation<Object>> constraintViolations) {
        Iterator<ConstraintViolation<Object>> iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            throw new ValidationException(iterator.next().getMessage());
        }
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
        executableValidator = validator.forExecutables();
    }
}

