/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.type;

import com.joe.utils.common.BeanUtils;
import com.joe.utils.scan.ClassScanner;
import com.joe.utils.scan.MethodScanner;
import com.joe.utils.type.BaseType;
import com.joe.utils.type.GenericType;
import com.joe.utils.type.JavaType;
import com.joe.utils.type.ReflectException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtil.class);
    private static final Logger logger = LoggerFactory.getLogger(ReflectUtil.class);
    private static final Pattern superPattern = Pattern.compile("(.*) super.*");
    private static final Pattern extendsPattern = Pattern.compile("(.*) extends.*");
    private static final ClassScanner CLASS_SCANNER = ClassScanner.getInstance();
    private static final MethodScanner METHOD_SCANNER = MethodScanner.getInstance();
    private static final Map<MethodKey, Method> CACHE = new HashMap<MethodKey, Method>();

    private ReflectUtil() {
    }

    public static <R> R invoke(Object obj, String methodName, Object ... args) {
        Method method = ReflectUtil.getMethod(obj.getClass(), methodName);
        try {
            return (R)method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ReflectException("\u8c03\u7528\u65b9\u6cd5[" + methodName + "]\u5931\u8d25", e);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        if (clazz == null || methodName == null) {
            throw new NullPointerException("clazz\u548cmethodName\u4e0d\u80fd\u4e3anull");
        }
        MethodKey key = new MethodKey(methodName, clazz);
        Method method = CACHE.get(key);
        if (method != null) {
            return method;
        }
        try {
            method = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectException("\u83b7\u53d6\u7c7b\u578b[" + clazz + "]\u7684\u65b9\u6cd5[" + methodName + "]\u5931\u8d25", e);
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException e) {
            log.warn("\u65e0\u6cd5\u66f4\u6539\u65b9\u6cd5[{}]\u7684\u8bbf\u95ee\u6743\u9650", (Object)method);
        }
        return method;
    }

    public static List<Class<?>> getAllAnnotationPresentClass(Class<? extends Annotation> annotation, String ... packages) {
        if (packages == null || packages.length == 0) {
            return Collections.emptyList();
        }
        log.debug("\u5f00\u59cb\u626b\u63cf\u5305{}\u4e0b\u7684\u5e26\u6ce8\u89e3[{}]\u7684\u5217\u8868", (Object)packages, annotation);
        List<Class<?>> classes = CLASS_SCANNER.scan(Collections.singletonList(clazz -> !clazz.isAnnotationPresent(annotation)), (Object[])packages);
        return classes;
    }

    public static List<Method> getAllAnnotationPresentMethod(Class<?> type, Class<? extends Annotation> annotation) {
        Method[] methods = type.getDeclaredMethods();
        if (methods.length == 0) {
            return Collections.emptyList();
        }
        return Stream.of(methods).filter(method -> method.isAnnotationPresent(annotation)).collect(Collectors.toList());
    }

    public static <T> T getFieldValue(Object obj, String fieldName) throws NoSuchFieldException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V, M extends Map<K, V>> JavaType createMapType(Class<M> m, Class<K> k, Class<V> v) {
        BaseType mapType = new BaseType();
        BaseType keyType = new BaseType();
        BaseType valueType = new BaseType();
        keyType.setType(k);
        valueType.setType(v);
        JavaType[] generics = new JavaType[]{keyType, valueType};
        mapType.setType(m);
        mapType.setGenerics(generics);
        return mapType;
    }

    public static <T, K extends Collection<T>> JavaType createCollectionType(Class<K> k, Class<T> t) {
        BaseType collectionType = new BaseType();
        BaseType genericType = new BaseType();
        genericType.setType(t);
        JavaType[] generics = new JavaType[]{genericType};
        collectionType.setType(k);
        collectionType.setGenerics(generics);
        return collectionType;
    }

    public static boolean isFinal(Field field) {
        int modifier = field.getModifiers();
        return ReflectUtil.isFinal(modifier);
    }

    public static boolean isFinal(Executable executable) {
        int modifier = executable.getModifiers();
        return ReflectUtil.isFinal(modifier);
    }

    public static boolean isPublic(Field field) {
        int modifier = field.getModifiers();
        return ReflectUtil.isPublic(modifier);
    }

    public static boolean isPublic(Executable executable) {
        int modifier = executable.getModifiers();
        return ReflectUtil.isPublic(modifier);
    }

    public static JavaType createJavaType(Type type) {
        BaseType baseType;
        JavaType javaType;
        if (type instanceof JavaType) {
            return (JavaType)type;
        }
        String typeName = type.getTypeName();
        if (type instanceof WildcardType) {
            logger.debug("\u7c7b\u578b{}\u662f\u4e0d\u786e\u5b9a\u7684\u6cdb\u578b", (Object)typeName);
            WildcardType wildcardTypeImpl = (WildcardType)type;
            Type[] child = wildcardTypeImpl.getLowerBounds();
            Type[] parent = wildcardTypeImpl.getUpperBounds();
            javaType = new GenericType();
            GenericType genericType = (GenericType)javaType;
            if (child.length > 0) {
                logger.debug("\u7c7b\u578b{}\u5fc5\u987b\u662f{}\u7684\u7236\u7c7b\u578b", (Object)typeName, (Object)child[0]);
                genericType.setChild(ReflectUtil.createJavaType(child[0]));
            } else {
                logger.debug("\u7c7b\u578b{}\u5fc5\u987b\u662f{}\u7684\u5b50\u7c7b\u578b", (Object)typeName, (Object)parent[0]);
                genericType.setParent(ReflectUtil.createJavaType(parent[0]));
            }
            genericType.setName(ReflectUtil.dealName(typeName));
        } else if (type instanceof ParameterizedType) {
            logger.debug("\u7c7b\u578b{}\u5b58\u5728\u6cdb\u578b", (Object)typeName);
            ParameterizedType parameterizedTypeImpl = (ParameterizedType)type;
            Type[] types = parameterizedTypeImpl.getActualTypeArguments();
            JavaType[] generics = new JavaType[types.length];
            for (int i = 0; i < types.length; ++i) {
                generics[i] = ReflectUtil.createJavaType(types[i]);
            }
            JavaType baseType2 = javaType = new BaseType();
            ((BaseType)baseType2).setType((Class)parameterizedTypeImpl.getRawType());
            ((BaseType)baseType2).setGenerics(generics);
            baseType2.setName(((BaseType)baseType2).getType().getSimpleName());
        } else if (type instanceof TypeVariable) {
            logger.debug("\u7c7b\u578b{}\u662f\u6cdb\u578b", (Object)typeName);
            TypeVariable typeVariableImpl = (TypeVariable)type;
            javaType = new GenericType();
            GenericType genericType = (GenericType)javaType;
            genericType.setParent(ReflectUtil.createJavaType(typeVariableImpl.getBounds()[0]));
            genericType.setName(ReflectUtil.dealName(type.getTypeName()));
        } else if (type instanceof Class) {
            javaType = new BaseType();
            baseType = javaType;
            Class clazz = (Class)type;
            baseType.setType(clazz);
            baseType.setName(clazz.getSimpleName());
        } else {
            throw new IllegalArgumentException("type[" + type + "]\u7c7b\u578b\u672a\u77e5");
        }
        if (javaType instanceof BaseType && !ReflectUtil.isSimple((baseType = javaType).getType())) {
            BeanUtils.CustomPropertyDescriptor[] props;
            TreeMap<String, JavaType> params = new TreeMap<String, JavaType>();
            for (BeanUtils.CustomPropertyDescriptor prop : props = BeanUtils.getPropertyDescriptors(baseType.getType())) {
                Annotation[] annotations;
                if ("class".equals(prop.getName())) continue;
                Annotation[] methodAnnotations = prop.getReadMethod().getAnnotations();
                try {
                    Field field = baseType.getType().getField(prop.getName());
                    Annotation[] fieldAnnotations = field.getAnnotations();
                    annotations = new Annotation[methodAnnotations.length + fieldAnnotations.length];
                    System.arraycopy(methodAnnotations, 0, annotations, 0, methodAnnotations.length);
                    System.arraycopy(fieldAnnotations, 0, annotations, methodAnnotations.length, fieldAnnotations.length);
                }
                catch (Exception e) {
                    annotations = new Annotation[methodAnnotations.length];
                    System.arraycopy(methodAnnotations, 0, annotations, 0, methodAnnotations.length);
                }
                JavaType filedType = ReflectUtil.createJavaType(prop.getReadMethod().getGenericReturnType());
                filedType.setAnnotations(annotations);
                params.put(prop.getName(), filedType);
            }
            baseType.setIncludes(params);
        }
        return javaType;
    }

    public static boolean isSimple(Class<?> clazz) throws NullPointerException {
        if (clazz == null) {
            throw new NullPointerException("Class\u4e0d\u80fd\u4e3anull");
        }
        return Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz);
    }

    public static boolean isBasic(Class<?> clazz) throws NullPointerException {
        if (clazz == null) {
            throw new NullPointerException("Class\u4e0d\u80fd\u4e3anull");
        }
        return Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz);
    }

    public static Class<?> getRealType(JavaType type) {
        if (type instanceof BaseType) {
            logger.debug("\u53c2\u6570\u4e0d\u662f\u6cdb\u578b\u7684");
            return ((BaseType)type).getType();
        }
        logger.debug("\u53c2\u6570\u662f\u6cdb\u578b\u7684");
        JavaType parent = ((GenericType)type).getParent();
        JavaType child = ((GenericType)type).getChild();
        return parent == null ? ReflectUtil.getRealType(child) : ReflectUtil.getRealType(parent);
    }

    public static boolean isGeneralType(Class<?> clazz) throws NullPointerException {
        if (clazz == null) {
            throw new NullPointerException("Class\u4e0d\u80fd\u4e3anull");
        }
        return clazz.isPrimitive();
    }

    public static boolean isGeneralArrayType(Class<?> clazz) throws NullPointerException {
        if (clazz == null) {
            throw new NullPointerException("Class\u4e0d\u80fd\u4e3anull");
        }
        String name = clazz.getName();
        return ReflectUtil.isGeneralArrayType(name);
    }

    public static boolean isGeneralArrayType(String name) {
        return "byte[]".equals(name) || "short[]".equals(name) || "int[]".equals(name) || "long[]".equals(name) || "double[]".equals(name) || "float[]".equals(name) || "boolean[]".equals(name) || "char[]".equals(name);
    }

    private static String dealName(String fullName) {
        Matcher matcher = superPattern.matcher(fullName);
        String name = matcher.find() ? matcher.group(1) : ((matcher = extendsPattern.matcher(fullName)).find() ? matcher.group(1) : fullName);
        return name;
    }

    private static boolean isFinal(int modifier) {
        return Modifier.isFinal(modifier);
    }

    private static boolean isPublic(int modifier) {
        return Modifier.isPublic(modifier);
    }

    private static class MethodKey {
        private String methodName;
        private Class<?> clazz;

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            return result;
        }

        public String toString() {
            return "ReflectUtil.MethodKey(methodName=" + this.getMethodName() + ", clazz=" + this.getClazz() + ")";
        }

        public MethodKey() {
        }

        public MethodKey(String methodName, Class<?> clazz) {
            this.methodName = methodName;
            this.clazz = clazz;
        }
    }
}

