/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.secure.impl;

import com.joe.utils.codec.IBase64;
import com.joe.utils.secure.CipherUtil;
import com.joe.utils.secure.KeyTools;
import com.joe.utils.secure.exception.SecureException;
import com.joe.utils.secure.impl.AbstractCipher;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetryCipher
extends AbstractCipher {
    private static final Logger log = LoggerFactory.getLogger(SymmetryCipher.class);
    private static final Map<String, SecretKey> KEY_CACHE = new HashMap<String, SecretKey>();

    private SymmetryCipher(CipherUtil.Algorithms algorithms, SecretKey key) {
        super(new String(key.getEncoded()), algorithms, key, key);
    }

    public static CipherUtil buildInstance(String seed) {
        return SymmetryCipher.buildInstance(CipherUtil.Algorithms.AES, seed, 128);
    }

    public static CipherUtil buildInstance(CipherUtil.Algorithms algorithms, String seed) {
        int keySize = 0;
        if (algorithms == CipherUtil.Algorithms.AES) {
            keySize = 128;
        } else if (algorithms == CipherUtil.Algorithms.DES) {
            keySize = 56;
        }
        return SymmetryCipher.buildInstance(algorithms, seed, keySize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CipherUtil buildInstance(CipherUtil.Algorithms algorithms, String seed, int keySize) {
        String id = (algorithms.name() + seed + keySize).intern();
        SecretKey key = KEY_CACHE.get(id);
        if (key == null) {
            String string = id;
            synchronized (string) {
                key = KEY_CACHE.get(id);
                if (key == null) {
                    key = KeyTools.buildKey(algorithms, seed, keySize);
                    KEY_CACHE.put(id, key);
                }
            }
        }
        return SymmetryCipher.buildInstance(algorithms, key.getEncoded());
    }

    public static CipherUtil buildInstance(CipherUtil.Algorithms algorithms, byte[] keySpec) {
        SecretKey key = KeyTools.buildKey(algorithms, keySpec);
        return new SymmetryCipher(algorithms, key);
    }

    @Override
    protected byte[] encrypt(AbstractCipher.CipherHolder holder, byte[] data) {
        try {
            return IBase64.encrypt(holder.getEncrypt().doFinal(data));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new SecureException("\u52a0\u5bc6\u7b97\u6cd5[" + (Object)((Object)holder.getAlgorithms()) + "]\u52a0\u5bc6\u6570\u636e\u5931\u8d25", e);
        }
    }

    @Override
    protected byte[] decrypt(AbstractCipher.CipherHolder holder, byte[] data) {
        try {
            return holder.getDecrypt().doFinal(IBase64.decrypt(data));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new SecureException("\u89e3\u5bc6\u7b97\u6cd5[" + (Object)((Object)holder.getAlgorithms()) + "]\u89e3\u5bc6\u6570\u636e\u5931\u8d25", e);
        }
    }
}

