/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.secure.impl;

import com.joe.utils.codec.IBase64;
import com.joe.utils.pool.ObjectPool;
import com.joe.utils.secure.KeyTools;
import com.joe.utils.secure.SignatureUtil;
import com.joe.utils.secure.exception.SecureException;
import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtilImpl
implements SignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtilImpl.class);
    private static final IBase64 BASE_64 = new IBase64();
    private static final Map<String, ObjectPool<SignatureHolder>> CACHE = new ConcurrentHashMap<String, ObjectPool<SignatureHolder>>();
    private final String id;

    private SignatureUtilImpl(String privateKey, String publicKey, SignatureUtil.Algorithms algorithms) {
        this.id = (privateKey + ":" + publicKey + ":" + algorithms.toString()).intern();
        CACHE.computeIfAbsent(this.id, id -> {
            ObjectPool<SignatureHolder> pool = new ObjectPool<SignatureHolder>(() -> SignatureUtilImpl.buildSignatureHolder(privateKey, publicKey, algorithms));
            pool.get().close();
            return pool;
        });
    }

    public static SignatureUtil buildInstance(String privateKey, String publicKey, SignatureUtil.Algorithms algorithms) {
        return new SignatureUtilImpl(privateKey, publicKey, algorithms);
    }

    @Override
    public String sign(String content) {
        return new String(this.sign(content.getBytes()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] sign(byte[] content) {
        try (ObjectPool.PoolObjectHolder<SignatureHolder> holder = CACHE.get(this.id).get();){
            Signature signature = holder.get().getSign();
            signature.update(content);
            byte[] byArray = IBase64.encrypt(signature.sign());
            return byArray;
        }
        catch (Exception e) {
            throw new SecureException("\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    @Override
    public boolean checkSign(String content, String data) {
        return this.checkSign(content.getBytes(), data.getBytes());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkSign(byte[] content, byte[] data) {
        try (ObjectPool.PoolObjectHolder<SignatureHolder> holder = CACHE.get(this.id).get();){
            Signature signature = holder.get().getVerify();
            signature.update(content);
            boolean bl = signature.verify(IBase64.decrypt(data));
            return bl;
        }
        catch (Exception e) {
            throw new SecureException("\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private static SignatureHolder buildSignatureHolder(String privateKey, String publicKey, SignatureUtil.Algorithms algorithms) {
        log.debug("\u6784\u5efaSignatureHolder");
        try {
            log.debug("\u6784\u5efa\u516c\u94a5\u4ee5\u53ca\u9a8c\u7b7e\u5668");
            RSAPublicKey pubKey = (RSAPublicKey)KeyTools.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature verify = Signature.getInstance(algorithms.toString());
            verify.initVerify(pubKey);
            log.debug("\u6784\u5efa\u79c1\u94a5\u4ee5\u53ca\u7b7e\u540d\u5668");
            RSAPrivateKey priKey = (RSAPrivateKey)KeyTools.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature sign = Signature.getInstance(algorithms.toString());
            sign.initSign(priKey);
            log.debug("SignatureHolder\u6784\u5efa\u6210\u529f");
            return new SignatureHolder(sign, verify, priKey, pubKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SecureException("\u521b\u5efa\u9a8c\u7b7e\u5668[" + (Object)((Object)algorithms) + "]\u5931\u8d25", e);
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SignatureUtilImpl) {
            SignatureUtilImpl signatureUtilImpl = (SignatureUtilImpl)obj;
            return signatureUtilImpl.id.equals(this.id);
        }
        return false;
    }

    private static class SignatureHolder {
        private Signature sign;
        private Signature verify;
        private RSAPrivateKey signKey;
        private PublicKey verifyKey;

        public Signature getSign() {
            return this.sign;
        }

        public Signature getVerify() {
            return this.verify;
        }

        public RSAPrivateKey getSignKey() {
            return this.signKey;
        }

        public PublicKey getVerifyKey() {
            return this.verifyKey;
        }

        public void setSign(Signature sign) {
            this.sign = sign;
        }

        public void setVerify(Signature verify) {
            this.verify = verify;
        }

        public void setSignKey(RSAPrivateKey signKey) {
            this.signKey = signKey;
        }

        public void setVerifyKey(PublicKey verifyKey) {
            this.verifyKey = verifyKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureHolder)) {
                return false;
            }
            SignatureHolder other = (SignatureHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Signature this$sign = this.getSign();
            Signature other$sign = other.getSign();
            if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
                return false;
            }
            Signature this$verify = this.getVerify();
            Signature other$verify = other.getVerify();
            if (this$verify == null ? other$verify != null : !this$verify.equals(other$verify)) {
                return false;
            }
            RSAPrivateKey this$signKey = this.getSignKey();
            RSAPrivateKey other$signKey = other.getSignKey();
            if (this$signKey == null ? other$signKey != null : !this$signKey.equals(other$signKey)) {
                return false;
            }
            PublicKey this$verifyKey = this.getVerifyKey();
            PublicKey other$verifyKey = other.getVerifyKey();
            return !(this$verifyKey == null ? other$verifyKey != null : !this$verifyKey.equals(other$verifyKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Signature $sign = this.getSign();
            result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
            Signature $verify = this.getVerify();
            result = result * 59 + ($verify == null ? 43 : $verify.hashCode());
            RSAPrivateKey $signKey = this.getSignKey();
            result = result * 59 + ($signKey == null ? 43 : $signKey.hashCode());
            PublicKey $verifyKey = this.getVerifyKey();
            result = result * 59 + ($verifyKey == null ? 43 : $verifyKey.hashCode());
            return result;
        }

        public String toString() {
            return "SignatureUtilImpl.SignatureHolder(sign=" + this.getSign() + ", verify=" + this.getVerify() + ", signKey=" + this.getSignKey() + ", verifyKey=" + this.getVerifyKey() + ")";
        }

        public SignatureHolder(Signature sign, Signature verify, RSAPrivateKey signKey, PublicKey verifyKey) {
            this.sign = sign;
            this.verify = verify;
            this.signKey = signKey;
            this.verifyKey = verifyKey;
        }

        public SignatureHolder() {
        }
    }
}

