/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.secure.impl;

import com.joe.utils.codec.Hex;
import com.joe.utils.pool.ObjectPool;
import com.joe.utils.secure.MessageDigestUtil;
import com.joe.utils.secure.exception.SecureException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageDigestUtilImpl
implements MessageDigestUtil {
    private static final Map<String, ObjectPool<MessageDigest>> CACHE = new ConcurrentHashMap<String, ObjectPool<MessageDigest>>();
    private MessageDigestUtil.Algorithms algorithms;

    private MessageDigestUtilImpl(MessageDigestUtil.Algorithms algorithms) {
        this.algorithms = algorithms;
        CACHE.computeIfAbsent(algorithms.name(), key -> {
            ObjectPool<MessageDigest> pool = new ObjectPool<MessageDigest>(() -> this.getMessageDigest(algorithms));
            pool.get().close();
            return pool;
        });
    }

    public static MessageDigestUtil buildInstance(MessageDigestUtil.Algorithms algorithms) {
        return new MessageDigestUtilImpl(algorithms);
    }

    private MessageDigest getMessageDigest(MessageDigestUtil.Algorithms algorithms) {
        try {
            return MessageDigest.getInstance(algorithms.getAlgorithms());
        }
        catch (NoSuchAlgorithmException exception) {
            throw new SecureException("\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u6307\u5b9a\u7684\u7b97\u6cd5\u63d0\u4f9b\u8005:[]", exception);
        }
    }

    @Override
    public String digest(String data) {
        return new String(Hex.encodeHex(this.digest(data.getBytes()), true));
    }

    @Override
    public byte[] digest(byte[] data) {
        try (ObjectPool.PoolObjectHolder<MessageDigest> holder = CACHE.get(this.algorithms.name()).get();){
            byte[] result;
            byte[] byArray = result = holder.get().digest(data);
            return byArray;
        }
    }
}

