/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.secure.impl;

import com.joe.utils.codec.IBase64;
import com.joe.utils.common.IOUtils;
import com.joe.utils.secure.CipherUtil;
import com.joe.utils.secure.KeyTools;
import com.joe.utils.secure.exception.SecureException;
import com.joe.utils.secure.impl.AbstractCipher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymmetricCipher
extends AbstractCipher {
    private static final Logger log = LoggerFactory.getLogger(AsymmetricCipher.class);

    private AsymmetricCipher(String id, CipherUtil.Algorithms algorithms, PrivateKey privateKey, PublicKey publicKey) {
        super(id, algorithms, privateKey, publicKey);
    }

    public static CipherUtil buildInstance(String privateKey, String publicKey) {
        return AsymmetricCipher.buildInstance(privateKey.getBytes(), publicKey.getBytes());
    }

    public static CipherUtil buildInstance(byte[] privateKey, byte[] publicKey) {
        PrivateKey priKey = KeyTools.getPrivateKeyFromPKCS8(CipherUtil.Algorithms.RSA.name(), new ByteArrayInputStream(privateKey));
        PublicKey pubKey = KeyTools.getPublicKeyFromX509(CipherUtil.Algorithms.RSA.name(), new ByteArrayInputStream(publicKey));
        return AsymmetricCipher.buildInstance(priKey, pubKey);
    }

    public static CipherUtil buildInstance(PrivateKey privateKey, PublicKey publicKey) {
        return new AsymmetricCipher(new String(IBase64.encrypt(privateKey.getEncoded())) + ":" + new String(IBase64.encrypt(publicKey.getEncoded())), CipherUtil.Algorithms.RSA, privateKey, publicKey);
    }

    @Override
    protected byte[] encrypt(AbstractCipher.CipherHolder holder, byte[] data) {
        return IBase64.encrypt(this.doCipher(holder.getEncrypt(), holder.getPublicKey(), data));
    }

    @Override
    protected byte[] decrypt(AbstractCipher.CipherHolder holder, byte[] data) {
        return this.doCipher(holder.getDecrypt(), holder.getPrivateKey(), IBase64.decrypt(data));
    }

    private byte[] doCipher(Cipher cipher, Key key, byte[] datas) {
        log.debug("\u5f00\u59cb\u975e\u5bf9\u79f0\u7684\u52a0\u89e3\u5bc6");
        RSAKey rsaKey = (RSAKey)((Object)key);
        int maxBlock = rsaKey.getModulus().bitLength() / 8;
        if (key instanceof RSAPublicKey) {
            maxBlock -= 11;
        }
        log.debug("\u5f53\u524dblock\u5927\u5c0f\u4e3a\uff1a[{}]\uff0c\u5f00\u59cb\u52a0/\u89e3\u5bc6", (Object)maxBlock);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int i = 0;
            int offset = 0;
            while (datas.length > offset) {
                if (datas.length - offset > maxBlock) {
                    out.write(cipher.doFinal(datas, offset, maxBlock));
                } else {
                    out.write(cipher.doFinal(datas, offset, datas.length - offset));
                }
                offset = maxBlock * ++i;
            }
            byte[] result = out.toByteArray();
            IOUtils.closeQuietly(out);
            return result;
        }
        catch (IOException | BadPaddingException | IllegalBlockSizeException e) {
            log.warn("RSA\u52a0/\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new SecureException(e);
        }
    }
}

