/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.secure.impl;

import com.joe.utils.codec.IBase64;
import com.joe.utils.pool.ObjectPool;
import com.joe.utils.secure.CipherUtil;
import com.joe.utils.secure.exception.SecureException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCipher
implements CipherUtil {
    private static final Logger log = LoggerFactory.getLogger(AbstractCipher.class);
    private static final Map<String, ObjectPool<CipherHolder>> CACHE = new ConcurrentHashMap<String, ObjectPool<CipherHolder>>();
    protected static final IBase64 BASE_64 = new IBase64();
    private String id;
    private CipherUtil.Algorithms algorithms;
    private Key priKey;
    private Key pubKey;

    AbstractCipher(String id, CipherUtil.Algorithms algorithms, Key priKey, Key pubKey) {
        this.id = id.intern();
        this.algorithms = algorithms;
        this.priKey = priKey;
        this.pubKey = pubKey;
        CACHE.computeIfAbsent(this.id, key -> {
            ObjectPool<CipherHolder> pool = new ObjectPool<CipherHolder>(this::build);
            pool.get().close();
            return pool;
        });
    }

    private CipherHolder build() {
        CipherUtil.Algorithms algorithms = this.getAlgorithms();
        Key priKey = this.getPrivateKey();
        Key pubKey = this.getPublicKey();
        log.debug("\u6784\u5efakey\u6210\u529f\uff0c\u5f00\u59cb\u6784\u5efaCipher");
        try {
            Cipher encrypt = Cipher.getInstance(algorithms.toString());
            encrypt.init(1, pubKey);
            Cipher decrypt = Cipher.getInstance(algorithms.toString());
            decrypt.init(2, priKey);
            log.debug("Cipher\u6784\u5efa\u6210\u529f");
            return new CipherHolder(algorithms, encrypt, decrypt, pubKey, priKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new SecureException("\u6784\u5efaCipherHolder[" + (Object)((Object)algorithms) + "]\u5931\u8d25", e);
        }
    }

    protected abstract byte[] encrypt(CipherHolder var1, byte[] var2);

    protected abstract byte[] decrypt(CipherHolder var1, byte[] var2);

    @Override
    public String encrypt(String content) {
        return new String(this.encrypt(content.getBytes()));
    }

    @Override
    public byte[] encrypt(byte[] content) {
        try (ObjectPool.PoolObjectHolder<CipherHolder> holder = CACHE.get(this.id).get();){
            byte[] byArray = this.encrypt(holder.get(), content);
            return byArray;
        }
    }

    @Override
    public String decrypt(String content) {
        return new String(this.decrypt(content.getBytes()));
    }

    @Override
    public byte[] decrypt(byte[] content) {
        try (ObjectPool.PoolObjectHolder<CipherHolder> holder = CACHE.get(this.id).get();){
            byte[] byArray = this.decrypt(holder.get(), content);
            return byArray;
        }
    }

    @Override
    public Key getPrivateKey() {
        return this.priKey;
    }

    @Override
    public Key getPublicKey() {
        return this.pubKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public CipherUtil.Algorithms getAlgorithms() {
        return this.algorithms;
    }

    protected static class CipherHolder {
        private CipherUtil.Algorithms algorithms;
        private Cipher encrypt;
        private Cipher decrypt;
        private Key publicKey;
        private Key privateKey;

        public CipherUtil.Algorithms getAlgorithms() {
            return this.algorithms;
        }

        public Cipher getEncrypt() {
            return this.encrypt;
        }

        public Cipher getDecrypt() {
            return this.decrypt;
        }

        public Key getPublicKey() {
            return this.publicKey;
        }

        public Key getPrivateKey() {
            return this.privateKey;
        }

        public void setAlgorithms(CipherUtil.Algorithms algorithms) {
            this.algorithms = algorithms;
        }

        public void setEncrypt(Cipher encrypt) {
            this.encrypt = encrypt;
        }

        public void setDecrypt(Cipher decrypt) {
            this.decrypt = decrypt;
        }

        public void setPublicKey(Key publicKey) {
            this.publicKey = publicKey;
        }

        public void setPrivateKey(Key privateKey) {
            this.privateKey = privateKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CipherHolder)) {
                return false;
            }
            CipherHolder other = (CipherHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CipherUtil.Algorithms this$algorithms = this.getAlgorithms();
            CipherUtil.Algorithms other$algorithms = other.getAlgorithms();
            if (this$algorithms == null ? other$algorithms != null : !((Object)((Object)this$algorithms)).equals((Object)other$algorithms)) {
                return false;
            }
            Cipher this$encrypt = this.getEncrypt();
            Cipher other$encrypt = other.getEncrypt();
            if (this$encrypt == null ? other$encrypt != null : !this$encrypt.equals(other$encrypt)) {
                return false;
            }
            Cipher this$decrypt = this.getDecrypt();
            Cipher other$decrypt = other.getDecrypt();
            if (this$decrypt == null ? other$decrypt != null : !this$decrypt.equals(other$decrypt)) {
                return false;
            }
            Key this$publicKey = this.getPublicKey();
            Key other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            Key this$privateKey = this.getPrivateKey();
            Key other$privateKey = other.getPrivateKey();
            return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CipherHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CipherUtil.Algorithms $algorithms = this.getAlgorithms();
            result = result * 59 + ($algorithms == null ? 43 : ((Object)((Object)$algorithms)).hashCode());
            Cipher $encrypt = this.getEncrypt();
            result = result * 59 + ($encrypt == null ? 43 : $encrypt.hashCode());
            Cipher $decrypt = this.getDecrypt();
            result = result * 59 + ($decrypt == null ? 43 : $decrypt.hashCode());
            Key $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            Key $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractCipher.CipherHolder(algorithms=" + (Object)((Object)this.getAlgorithms()) + ", encrypt=" + this.getEncrypt() + ", decrypt=" + this.getDecrypt() + ", publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ")";
        }

        public CipherHolder(CipherUtil.Algorithms algorithms, Cipher encrypt, Cipher decrypt, Key publicKey, Key privateKey) {
            this.algorithms = algorithms;
            this.encrypt = encrypt;
            this.decrypt = decrypt;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public CipherHolder() {
        }
    }
}

