/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.secure;

import com.joe.utils.codec.IBase64;
import com.joe.utils.common.IOUtils;
import com.joe.utils.common.StringUtils;
import com.joe.utils.secure.CipherUtil;
import com.joe.utils.secure.exception.SecureException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTools {
    private static final Logger log = LoggerFactory.getLogger(KeyTools.class);
    private static final IBase64 BASE_64 = new IBase64();

    public static KeyHolder buildRSAKey(int keySize) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(keySize);
            KeyPair keyPair = generator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            return new KeyHolder(privateKey, publicKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecureException("\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u63d0\u4f9b\u751f\u6210RSA\u5bc6\u94a5\u5bf9\u7684\u7b97\u6cd5", e);
        }
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) {
        if (ins == null || StringUtils.isEmpty(algorithm)) {
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = IOUtils.read(ins);
            encodedKey = IBase64.decrypt(encodedKey);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new SecureException("\u6784\u5efa[" + algorithm + "]\u79c1\u94a5\u5931\u8d25", e);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) {
        if (ins == null || StringUtils.isEmpty(algorithm)) {
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = IOUtils.read(ins);
            encodedKey = IBase64.decrypt(encodedKey);
            return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new SecureException("\u6784\u5efa[" + algorithm + "]\u79c1\u94a5\u5931\u8d25", e);
        }
    }

    public static SecretKey buildKey(CipherUtil.Algorithms algorithm, String seed, int keySize) {
        log.debug("\u5f00\u59cb\u6784\u5efa\u5bf9\u79f0\u52a0\u5bc6[{}]\u7684Key\uff0cKeysize\u4e3a\uff1a[{}]", (Object)algorithm, (Object)keySize);
        String name = algorithm.name();
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(name);
            kgen.init(keySize, new SecureRandom(seed.getBytes()));
            return kgen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecureException("\u6784\u5efa[" + (Object)((Object)algorithm) + "]\u7684key\u5931\u8d25\uff0ckeySize\u662f\uff1a" + keySize, e);
        }
    }

    public static SecretKey buildKey(CipherUtil.Algorithms algorithm, byte[] keySpec) {
        SecretKeySpec key = new SecretKeySpec(keySpec, algorithm.name());
        return key;
    }

    public static class KeyHolder {
        private PrivateKey privateKey;
        private PublicKey publicKey;

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public void setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
        }

        public void setPublicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyHolder)) {
                return false;
            }
            KeyHolder other = (KeyHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PrivateKey this$privateKey = this.getPrivateKey();
            PrivateKey other$privateKey = other.getPrivateKey();
            if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                return false;
            }
            PublicKey this$publicKey = this.getPublicKey();
            PublicKey other$publicKey = other.getPublicKey();
            return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeyHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PrivateKey $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            PublicKey $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            return result;
        }

        public String toString() {
            return "KeyTools.KeyHolder(privateKey=" + this.getPrivateKey() + ", publicKey=" + this.getPublicKey() + ")";
        }

        public KeyHolder(PrivateKey privateKey, PublicKey publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }
    }
}

