/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.scan;

import com.joe.utils.common.ClassUtils;
import com.joe.utils.scan.ClassFilter;
import com.joe.utils.scan.Scanner;
import com.joe.utils.scan.ScannerException;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScanner
implements Scanner<Class<?>, ClassFilter> {
    private static final Logger logger = LoggerFactory.getLogger(ClassScanner.class);
    private static Map<ClassLoader, ClassScanner> classScannerMap = new ConcurrentHashMap<ClassLoader, ClassScanner>();
    private ClassLoader classLoader;

    private ClassScanner() {
    }

    public static ClassScanner getInstance() {
        return ClassScanner.getInstance(ClassUtils.getDefaultClassLoader());
    }

    public static ClassScanner getInstance(ClassLoader classLoader) {
        ClassScanner scanner = classScannerMap.putIfAbsent(classLoader, new ClassScanner());
        if (scanner == null) {
            scanner = classScannerMap.get(classLoader);
            scanner.classLoader = classLoader;
        }
        return scanner;
    }

    @Override
    public List<Class<?>> scan(Object ... args) {
        if (args == null || args.length == 0) {
            return Collections.emptyList();
        }
        List<Class<?>> result = null;
        for (Object obj : args) {
            List<Class<?>> list = this.scan((String)obj);
            if (result == null) {
                result = list;
                continue;
            }
            result.addAll(list);
        }
        return result;
    }

    @Override
    public List<Class<?>> scan(List<ClassFilter> excludeFilters, Object ... args) throws ScannerException {
        logger.debug("\u641c\u7d22\u626b\u63cf\u6240\u6709\u7684\u7c7b\uff0c\u8fc7\u6ee4\u5668\u4e3a\uff1a{}\uff0c\u53c2\u6570\u4e3a\uff1a{}", excludeFilters, (Object)args);
        if (args == null || args.length == 0) {
            return Collections.emptyList();
        }
        for (Object arg : args) {
            if (arg instanceof String) continue;
            logger.debug("\u53c2\u6570\u7c7b\u578b\u4e3a\uff1a{}", args.getClass());
            throw new ScannerException("\u53c2\u6570\u7c7b\u578b\u4e3a\uff1a" + args.getClass());
        }
        List<Class<?>> result = null;
        for (Object obj : args) {
            List<Class<?>> list = this.scan((String)obj, excludeFilters);
            if (result == null) {
                result = list;
                continue;
            }
            result.addAll(list);
        }
        return result;
    }

    public List<Class<?>> scan(String pack, List<ClassFilter> filters) {
        Enumeration<URL> dirs;
        logger.debug("\u5f00\u59cb\u626b\u63cf\u5305{}\u4e0b\u7684\u6240\u6709\u7c7b\u7684\u96c6\u5408", (Object)pack);
        List<Class<Object>> classes = new ArrayList();
        String packageDirName = pack.replace('.', '/');
        try {
            dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        }
        catch (IOException e) {
            logger.error("\u626b\u63cf\u5305{}\u8d44\u6e90\u51fa\u9519", (Object)packageDirName);
            throw new RuntimeException(e);
        }
        while (dirs.hasMoreElements()) {
            try {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    logger.debug("file\u7c7b\u578b\u626b\u63cf");
                    String filePath = URLDecoder.decode(url.getFile(), Charset.defaultCharset().name());
                    classes.addAll(this.findAndAddClassesInPackageByFile(pack, filePath, true));
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                classes.addAll(this.findAndAddClassesInPackageByFile(jar, packageDirName, pack, true));
            }
            catch (Throwable e) {
                logger.debug("\u626b\u63cf{}\u65f6\u51fa\u9519", (Object)pack, (Object)e);
            }
        }
        if (!filters.isEmpty()) {
            logger.debug("\u626b\u63cf\u5b8c\u6bd5\uff0c\u626b\u63cf\u51fa\u6765\u7684Class\u96c6\u5408\u4e3a\uff1a{}\uff0c\u53d1\u73b0\u8fc7\u6ee4\u5668\uff0c\u4f7f\u7528\u8fc7\u6ee4\u5668\u8fc7\u6ee4", classes);
            classes = classes.stream().filter(clazz -> this.filter((Class<?>)clazz, filters)).collect(Collectors.toList());
            logger.debug("\u8fc7\u6ee4\u540e\u7684Class\u4e3a\uff1a{}", classes);
        }
        return classes;
    }

    private List<Class<?>> scan(String packageName) {
        return this.scan(packageName, Collections.emptyList());
    }

    public Set<Class<?>> findAndAddClassesInPackageByFile(JarFile jar, String packageDirName, String packageName, boolean recursive) {
        logger.debug("\u5c1d\u8bd5\u626b\u63cfjar\u6587\u4ef6{}");
        LinkedHashSet classes = new LinkedHashSet();
        logger.debug("jar\u7c7b\u578b\u7684\u626b\u63cf");
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDirName)) continue;
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                packageName = name.substring(0, idx).replace('/', '.');
            }
            if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(packageName.length() + 1, name.length() - 6);
            className = packageName + "." + className;
            try {
                logger.debug("\u5c1d\u8bd5\u6784\u5efaclass\uff1a{}", (Object)className);
                classes.add(this.classLoader.loadClass(className));
            }
            catch (Throwable e) {
                logger.warn("\u627e\u4e0d\u5230{}\u6587\u4ef6", (Object)(className + ".class"), (Object)e);
            }
        }
        return classes;
    }

    private boolean filter(Class<?> clazz, List<ClassFilter> filters) {
        boolean flag = true;
        for (ClassFilter filter : filters) {
            if (!filter.filter(clazz)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public Set<Class<?>> findAndAddClassesInPackageByFile(String packageName, String packagePath, boolean recursive) {
        logger.debug("\u626b\u63cf\u5305{}\u4e0b\u3001\u76ee\u5f55{}\u4e0b\u7684\u6240\u6709class", (Object)packageName, (Object)packagePath);
        LinkedHashSet classes = new LinkedHashSet();
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            logger.debug("\u7528\u6237\u5b9a\u4e49\u5305\u540d " + packageName + " \u4e0b\u6ca1\u6709\u4efb\u4f55\u6587\u4ef6");
            return Collections.emptySet();
        }
        File[] dirfiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"));
        if (dirfiles == null || dirfiles.length == 0) {
            return Collections.emptySet();
        }
        for (File file2 : dirfiles) {
            if (file2.isDirectory()) {
                classes.addAll(this.findAndAddClassesInPackageByFile(packageName + "/" + file2.getName(), file2.getAbsolutePath(), recursive));
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            try {
                packageName = packageName.replaceAll("/", ".");
                className = packageName + '.' + className;
                classes.add(this.classLoader.loadClass(className));
            }
            catch (Throwable e) {
                logger.error("\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6", e);
            }
        }
        return classes;
    }
}

