/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.protocol;

import com.joe.utils.collection.ByteArray;
import com.joe.utils.common.Tools;
import com.joe.utils.pool.ObjectPool;
import com.joe.utils.protocol.Datagram;
import com.joe.utils.protocol.exception.DataOutOfMemory;
import com.joe.utils.protocol.exception.IllegalDataException;
import com.joe.utils.protocol.exception.IllegalRequestException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramUtil {
    private static final Logger logger = LoggerFactory.getLogger(DatagramUtil.class);
    private static final ObjectPool<ByteArray> POOL = new ObjectPool<ByteArray>(() -> new ByteArray(512));
    private static final int MAX_LENGTH = 0x7FFFFFC7;

    public static Datagram build(byte[] body, byte type, byte version) throws DataOutOfMemory {
        int dataLen = 0;
        if (body != null && body.length != 0) {
            dataLen = body.length;
            logger.debug("\u8981\u6784\u5efa\u7684\u6570\u636e\u62a5\u7684body\u957f\u5ea6\u4e3a\uff1a{}", (Object)dataLen);
        } else {
            logger.debug("\u8981\u6784\u5efa\u4e00\u4e2a\u7a7a\u7684\u6570\u636e\u62a5");
        }
        logger.debug("\u8981\u53d1\u9001\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)body);
        if (dataLen > 0x7FFFFFC7) {
            logger.error("\u6570\u636e\u62a5\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u6700\u5927\u503c\uff1a{}", (Object)0x7FFFFFC7);
            throw new DataOutOfMemory(String.format("\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u6700\u5927\u503c%d", 0x7FFFFFC7));
        }
        try (ObjectPool.PoolObjectHolder<ByteArray> holder = POOL.get();){
            ByteArray buffer = holder.get();
            buffer.append(version);
            buffer.append(DatagramUtil.convert(dataLen));
            buffer.append(type);
            String charset = Charset.defaultCharset().name();
            ByteArray charsetBuffer = new ByteArray(10);
            charsetBuffer.append(charset.getBytes());
            if (charsetBuffer.size() > 10) {
                throw new DataOutOfMemory("\u6570\u636e\u62a5\u5b57\u7b26\u96c6\u957f\u5ea6\u6700\u5927\u4e3a10byte\uff0c\u5f53\u524d\u7cfb\u7edf\u9ed8\u8ba4\u5b57\u7b26\u96c6\u8d85\u8fc7\u8be5\u957f\u5ea6");
            }
            while (charsetBuffer.size() < 10) {
                charsetBuffer.append((byte)0);
            }
            buffer.append(charsetBuffer.getData());
            String id = Tools.createUUID();
            ByteArray idByte = new ByteArray(40);
            idByte.append(id.getBytes());
            for (int i = 0; i < 40 - id.getBytes().length; ++i) {
                idByte.append((byte)0);
            }
            byte[] ids = idByte.getData();
            buffer.append(ids);
            if (dataLen != 0) {
                buffer.append(body);
            }
            Datagram datagram = new Datagram(buffer.getData(), dataLen, body, version, charset, type, ids);
            logger.debug("\u8f6c\u6362\u540e\u7684\u6570\u636e\u62a5\u662f\uff1a{}", (Object)datagram);
            Datagram datagram2 = datagram;
            return datagram2;
        }
    }

    public static Datagram decode(byte[] data) throws IllegalRequestException {
        return DatagramUtil.decode(data, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Datagram decode(byte[] data, boolean allowErr) throws IllegalRequestException {
        try {
            byte[] buffer;
            logger.debug("\u8981\u89e3\u6790\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)data);
            ByteArray charsetData = new ByteArray(10);
            for (int i = 6; i < 16 && data[i] != 0; ++i) {
                charsetData.append(data[i]);
            }
            String charset = new String(charsetData.getData());
            byte version = data[0];
            byte type = data[5];
            int len = DatagramUtil.readLen(data);
            logger.debug("\u8981\u89e3\u6790\u7684\u6570\u636e\u62a5\u7684\u5b57\u7b26\u96c6\u4e3a\uff1a{}\uff0c\u7248\u672c\u53f7\u4e3a\uff1a{}\uff0c\u6570\u636e\u62a5\u7c7b\u578b\u4e3a\uff1a{}", new Object[]{charset, version, type});
            if (data.length - 56 > len) {
                logger.warn("\u6570\u636e\u62a5head\u4e2d\u7684\u957f\u5ea6\u5b57\u6bb5\u4e3a\uff1a{}\uff0c\u6570\u636e\u62a5body\u7684\u5b9e\u9645\u957f\u5ea6\u4e3a\uff1a{}", (Object)len, (Object)(data.length - 56));
                if (!allowErr) throw new IllegalDataException("\u6570\u636e\u62a5head\u4e2d\u7684\u957f\u5ea6\u5b57\u6bb5\u4e3a\uff1a" + len + "\uff0c\u6570\u636e\u62a5body\u7684\u5b9e\u9645\u957f\u5ea6\u4e3a\uff1a" + (data.length - 56));
                buffer = new byte[len + 56];
                System.arraycopy(data, 0, buffer, 0, buffer.length);
            } else {
                if (data.length - 56 < len) {
                    logger.error("\u6570\u636e\u62a5head\u4e2d\u7684\u957f\u5ea6\u5b57\u6bb5\u4e3a\uff1a{}\uff0c\u6570\u636e\u62a5body\u7684\u5b9e\u9645\u957f\u5ea6\u4e3a\uff1a{}", (Object)len, (Object)(data.length - 56));
                    throw new IllegalDataException("\u6570\u636e\u62a5head\u4e2d\u7684\u957f\u5ea6\u5b57\u6bb5\u4e3a\uff1a" + len + "\uff0c\u6570\u636e\u62a5body\u7684\u5b9e\u9645\u957f\u5ea6\u4e3a\uff1a" + (data.length - 56));
                }
                buffer = data;
            }
            logger.debug("\u83b7\u53d6id\u5b57\u6bb5");
            byte[] idByte = new byte[40];
            System.arraycopy(data, 16, idByte, 0, idByte.length);
            String id = new String(idByte);
            logger.debug("\u6570\u636e\u62a5ID\u4e3a\uff1a{}", (Object)id);
            if (len == 0) {
                logger.debug("\u8981\u89e3\u6790\u7684\u6570\u636e\u4e2dhead\u6807\u5fd7body\u957f\u5ea6\u4e3a0\uff0c\u76f4\u63a5\u8fd4\u56de\u4e00\u4e2a\u7a7abody\u7684datagram\u5bf9\u8c61");
                Datagram datagram = new Datagram(buffer, len, null, version, charset, type, idByte);
                logger.debug("\u5c01\u88c5\u597d\u7684\u6570\u636e\u62a5body\u4e3a\uff1a{}", (Object)datagram);
                return datagram;
            }
            byte[] body = new byte[len];
            System.arraycopy(buffer, 56, body, 0, body.length);
            Datagram datagram = new Datagram(buffer, len, body, version, charset, type, idByte);
            logger.debug("\u5c01\u88c5\u597d\u7684\u6570\u636e\u62a5body\u4e3a\uff1a{}", (Object)datagram);
            return datagram;
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u62a5\u89e3\u6790\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Throwable)e);
            throw new IllegalRequestException(e);
        }
    }

    public static int readLen(byte[] data) {
        if (data.length < 56) {
            logger.warn("\u8981\u8bfb\u53d6\u957f\u5ea6\u7684\u6570\u636e\u62a5\u62a5\u5934\u4e0d\u5b8c\u6574");
            return -1;
        }
        return DatagramUtil.convert(data, 1);
    }

    public static byte[] convert(int data) {
        long len = Integer.toUnsignedLong(data);
        byte[] b = new byte[4];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(len >> (b.length - i - 1) * 8);
        }
        return b;
    }

    public static int convert(byte[] data) {
        return DatagramUtil.convert(data, 0);
    }

    public static int convert(byte[] data, int start) {
        return Byte.toUnsignedInt(data[start]) << 24 | Byte.toUnsignedInt(data[start + 1]) << 16 | Byte.toUnsignedInt(data[start + 2]) << 8 | Byte.toUnsignedInt(data[start + 3]);
    }
}

