/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.protocol;

import java.util.Arrays;

public class Datagram {
    private static final byte[] EMPTY_DATA = new byte[0];
    public static final byte HEARTBEAT = 0;
    public static final byte MVC = 1;
    public static final byte FILE = 2;
    public static final byte ACK = 3;
    public static final byte BACK = 4;
    private static final byte[] ACKS = new byte[]{1, 2, 4};
    public static final int HEADER_LEN = 56;
    public static final int VERSION_INDEX = 0;
    public static final int LEN_OFFSET = 1;
    public static final int LEN_LIMIT = 4;
    public static final int TYPE_INDEX = 5;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    private final byte[] data;
    private final int size;
    private final byte version;
    private final String charset;
    private final byte[] body;
    private final byte type;
    private final byte[] id;

    public Datagram(byte[] data, int size, byte[] body, byte version, String charset, byte type, byte[] id) {
        if (data == null) {
            this.data = EMPTY_DATA;
        } else {
            this.data = new byte[data.length];
            System.arraycopy(data, 0, this.data, 0, data.length);
        }
        if (body == null) {
            this.body = EMPTY_DATA;
        } else {
            this.body = new byte[body.length];
            System.arraycopy(body, 0, this.body, 0, body.length);
        }
        this.size = size;
        this.version = version;
        this.charset = charset;
        this.type = type;
        this.id = id;
    }

    public byte[] getData() {
        if (this.data == null || this.data.length == 0) {
            return EMPTY_DATA;
        }
        byte[] data = new byte[this.data.length];
        System.arraycopy(this.data, 0, data, 0, data.length);
        return data;
    }

    public byte[] getBody() {
        if (this.body == null || this.body.length == 0) {
            return EMPTY_DATA;
        }
        byte[] body = new byte[this.body.length];
        System.arraycopy(this.body, 0, body, 0, body.length);
        return body;
    }

    public boolean ack() {
        return Datagram.shouldAck(this.type);
    }

    public static boolean shouldAck(byte type) {
        for (byte b : ACKS) {
            if (type != b) continue;
            return true;
        }
        return false;
    }

    public static boolean isAck(byte type) {
        return type == 3;
    }

    public static boolean isHeartbeat(byte type) {
        return type == 0;
    }

    public static boolean isFile(byte type) {
        return type == 2;
    }

    public static boolean isBack(byte type) {
        return type == 4;
    }

    public int getSize() {
        return this.size;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getCharset() {
        return this.charset;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Datagram)) {
            return false;
        }
        Datagram other = (Datagram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        return Arrays.equals(this.getId(), other.getId());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Datagram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getData());
        result = result * 59 + this.getSize();
        result = result * 59 + this.getVersion();
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        result = result * 59 + this.getType();
        result = result * 59 + Arrays.hashCode(this.getId());
        return result;
    }

    public String toString() {
        return "Datagram(data=" + Arrays.toString(this.getData()) + ", size=" + this.getSize() + ", version=" + this.getVersion() + ", charset=" + this.getCharset() + ", body=" + Arrays.toString(this.getBody()) + ", type=" + this.getType() + ", id=" + Arrays.toString(this.getId()) + ")";
    }
}

