/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.pool;

import com.joe.utils.function.GetObjectFunction;
import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;

public class ObjectPool<T> {
    private Deque<PoolObjectHolder<T>> pool = new LinkedBlockingDeque<PoolObjectHolder<T>>();
    private GetObjectFunction<T> function;

    public ObjectPool(GetObjectFunction<T> function) {
        this.function = function;
    }

    public PoolObjectHolder<T> get() {
        PoolObjectHolder<T> data = this.pool.pollLast();
        if (data == null) {
            data = new PoolObjectHolder(this.function.get(), this);
        }
        return data;
    }

    public int size() {
        return this.pool.size();
    }

    public void clear(int size) {
        if (size <= 0) {
            return;
        }
        while (size-- > 0) {
            this.pool.pollLast();
        }
    }

    public void clear() {
        this.clear(this.size());
    }

    public static class PoolObjectHolder<T>
    implements AutoCloseable {
        private T data;
        private ObjectPool<T> pool;
        private boolean closed = false;

        private PoolObjectHolder(T data, ObjectPool<T> pool) {
            this.data = data;
            this.pool = pool;
        }

        public T get() {
            return this.data;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            ((ObjectPool)this.pool).pool.addLast(this);
            this.closed = true;
        }
    }
}

