/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.poi;

import com.joe.utils.poi.CellStyleAccesser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class WorkBookAccesser {
    private final Workbook workbook;
    private volatile int sheetIndex;

    public WorkBookAccesser(Workbook workbook) {
        this(workbook, 0);
    }

    public WorkBookAccesser(Workbook workbook, int sheetIndex) {
        this.workbook = workbook;
        this.sheetIndex = sheetIndex;
    }

    public void useSheet(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public Cell getCell(int column, int row) {
        return this.workbook.getSheetAt(this.sheetIndex).getRow(row).getCell(column);
    }

    public CellStyleAccesser getCellStyleAccesser(int column, int row) {
        return CellStyleAccesser.build(this.getCell(column, row));
    }

    public void mergedRowRegion(int row, int firstCol, int lastCol) {
        this.mergedRegion(row, row, firstCol, lastCol);
    }

    public void mergedColumnRegion(int column, int firstRow, int lastRow) {
        this.mergedRegion(firstRow, lastRow, column, column);
    }

    public void mergedRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        this.mergedRegion(this.workbook.getSheetAt(this.sheetIndex), firstRow, lastRow, firstCol, lastCol);
    }

    public void mergedRegion(String sheetName, int firstRow, int lastRow, int firstCol, int lastCol) {
        this.mergedRegion(this.workbook.getSheet(sheetName), firstRow, lastRow, firstCol, lastCol);
    }

    private void mergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }
}

