/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.poi;

import com.joe.utils.collection.CollectionUtil;
import com.joe.utils.common.BeanUtils;
import com.joe.utils.common.StringUtils;
import com.joe.utils.exception.UtilsException;
import com.joe.utils.poi.ExcelColumn;
import com.joe.utils.poi.ExcelDataWriter;
import com.joe.utils.poi.data.BooleanDataWriter;
import com.joe.utils.poi.data.CalendarDataWriter;
import com.joe.utils.poi.data.DateDataWriter;
import com.joe.utils.poi.data.EnumDataWriter;
import com.joe.utils.poi.data.NumberDataWriter;
import com.joe.utils.poi.data.StringDataWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExcelExecutor.class);
    private static final int IN_MEMORY = 100;
    private static final Comparator<Field> COMPARATOR = (f1, f2) -> {
        ExcelColumn c1 = f1.getAnnotation(ExcelColumn.class);
        ExcelColumn c2 = f2.getAnnotation(ExcelColumn.class);
        if (c1 == null && c2 == null) {
            return f1.getName().compareTo(f2.getName());
        }
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return c1.sort() - c2.sort();
    };
    private static final ExcelExecutor UTILS = new ExcelExecutor();
    private final Map<Class<?>, ExcelDataWriter<?>> writers = new HashMap();

    private ExcelExecutor() {
        this.init();
    }

    private void init() {
        this.writers.put(Boolean.class, new BooleanDataWriter());
        this.writers.put(Calendar.class, new CalendarDataWriter());
        this.writers.put(Date.class, new DateDataWriter());
        this.writers.put(Enum.class, new EnumDataWriter());
        this.writers.put(Number.class, new NumberDataWriter());
        this.writers.put(String.class, new StringDataWriter());
    }

    public static ExcelExecutor getInstance() {
        return UTILS;
    }

    public static ExcelExecutor buildInstance() {
        return new ExcelExecutor();
    }

    public <T> ExcelDataWriter<?> registerDataWriter(Class<T> type, ExcelDataWriter<T> writer) {
        if (writer != null) {
            return this.writers.put(type, writer);
        }
        return null;
    }

    public <T> boolean containsDataWriter(Class<T> type) {
        return this.writers.containsKey(type);
    }

    public void writeToExcel(List<? extends Object> datas, boolean hasTitle, String path) throws IOException {
        this.writeToExcel(datas, hasTitle, path, false);
    }

    public void writeToExcel(List<? extends Object> datas, boolean hasTitle, String path, boolean transverse) throws IOException {
        this.writeToExcel(datas, hasTitle, path, 100, transverse);
    }

    public void writeToExcel(List<? extends Object> datas, boolean hasTitle, String path, int inMemory) throws IOException {
        this.writeToExcel(datas, hasTitle, path, inMemory, false);
    }

    public void writeToExcel(List<? extends Object> datas, boolean hasTitle, String path, int inMemory, boolean transverse) throws IOException {
        this.writeToExcel(datas, hasTitle, new FileOutputStream(path), inMemory, transverse);
    }

    public void writeToExcel(List<? extends Object> datas, boolean hasTitle, OutputStream outputStream) throws IOException {
        this.writeToExcel(datas, hasTitle, outputStream, false);
    }

    public void writeToExcel(List<? extends Object> datas, boolean hasTitle, OutputStream outputStream, boolean transverse) throws IOException {
        this.writeToExcel(datas, hasTitle, outputStream, 100, transverse);
    }

    public void writeToExcel(List<? extends Object> datas, boolean hasTitle, OutputStream outputStream, int inMemory) throws IOException {
        this.writeToExcel(datas, hasTitle, outputStream, inMemory, false);
    }

    public void writeToExcel(List<? extends Object> datas, boolean hasTitle, OutputStream outputStream, int inMemory, boolean transverse) throws IOException {
        log.info("\u51c6\u5907\u5c06\u6570\u636e\u5199\u5165excel");
        SXSSFWorkbook wb = new SXSSFWorkbook(inMemory);
        this.writeToExcel(datas, hasTitle, (Workbook)wb, transverse);
        log.info("\u6570\u636e\u5199\u5165excel\u5b8c\u6bd5\uff0c\u51c6\u5907\u5199\u5165\u672c\u5730\u6587\u4ef6");
        wb.write(outputStream);
        log.debug("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\uff0c\u5173\u95edWorkbook");
        wb.dispose();
        wb.close();
    }

    public Workbook writeToExcel(List<? extends Object> datas, boolean hasTitle, Workbook workbook) {
        return this.writeToExcel(datas, hasTitle, workbook, false);
    }

    public Workbook writeToExcel(List<? extends Object> datas, boolean hasTitle, Workbook workbook, boolean transverse) {
        if (CollectionUtil.safeIsEmpty(datas)) {
            log.warn("\u7ed9\u5b9a\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
            return workbook;
        }
        if ((datas = datas.parallelStream().filter(data -> data != null).collect(Collectors.toList())).isEmpty()) {
            log.warn("\u7ed9\u5b9a\u6570\u636e\u96c6\u5408\u91cc\u7684\u6570\u636e\u5168\u662f\u7a7a");
            return workbook;
        }
        Field[] fields = BeanUtils.getAllFields(datas.get(0).getClass());
        log.info("\u83b7\u53d6\u53ef\u5199\u5165excel\u7684\u5b57\u6bb5");
        ArrayList<Field> writeFields = new ArrayList<Field>();
        for (Field field : fields) {
            String name = field.getName();
            log.debug("\u68c0\u67e5\u5b57\u6bb5[{}]\u662f\u5426\u53ef\u4ee5\u5199\u5165", (Object)name);
            Class<?> type = field.getType();
            List data2 = this.writers.values().stream().filter(excelData -> excelData.writeable(type)).collect(Collectors.toList());
            if (data2.isEmpty()) {
                log.info("\u5b57\u6bb5[{}]\u4e0d\u80fd\u5199\u5165", (Object)name);
                continue;
            }
            log.info("\u5b57\u6bb5[{}]\u53ef\u4ee5\u5199\u5165excel");
            ExcelColumn column = field.getAnnotation(ExcelColumn.class);
            if (column != null && column.ignore()) continue;
            writeFields.add(field);
        }
        log.debug("\u53ef\u5199\u5165excel\u7684\u5b57\u6bb5\u96c6\u5408\u4e3a\uff1a[{}]", writeFields);
        log.debug("\u5bf9\u53ef\u5199\u5165excel\u7684\u5b57\u6bb5\u96c6\u5408\u6392\u5e8f");
        Collections.sort(writeFields, COMPARATOR);
        log.debug("\u53ef\u5199\u5165excel\u7684\u5b57\u6bb5\u96c6\u5408\u6392\u5e8f\u5b8c\u6bd5\uff0c\u6784\u5efa\u6807\u9898\u5217\u8868");
        ArrayList titles = null;
        if (hasTitle) {
            log.info("\u5f53\u524d\u9700\u8981\u6807\u9898\u5217\u8868\uff0c\u6784\u5efa...");
            titles = new ArrayList(writeFields.size());
            for (int i = 0; i < writeFields.size(); ++i) {
                Field field = (Field)writeFields.get(i);
                ExcelColumn column = field.getAnnotation(ExcelColumn.class);
                if (column == null || StringUtils.isEmpty(column.value())) {
                    titles.add(this.build(field.getName()));
                    continue;
                }
                titles.add(this.build(column.value()));
            }
        }
        log.debug("\u6784\u5efa\u5355\u5143\u683c\u6570\u636e");
        ArrayList writeDatas = new ArrayList(datas.size());
        for (int i = 0; i < datas.size(); ++i) {
            Object dataValue = datas.get(i);
            ArrayList columnDatas = new ArrayList(writeFields.size());
            writeDatas.add(columnDatas);
            for (int j = 0; j < writeFields.size(); ++j) {
                Field field = (Field)writeFields.get(j);
                try {
                    log.debug("\u83b7\u53d6[{}]\u4e2d\u5b57\u6bb5[{}]\u7684\u503c", dataValue, (Object)field.getName());
                    Object value = field.get(dataValue);
                    columnDatas.add(this.build(value));
                    continue;
                }
                catch (IllegalAccessException e) {
                    log.warn("[{}]\u4e2d\u5b57\u6bb5[{}]\u4e0d\u80fd\u8bfb\u53d6", new Object[]{dataValue, field.getName(), e});
                    columnDatas.add(null);
                }
            }
        }
        log.debug("\u8981\u5199\u5165\u7684\u6570\u636e\u4e3a\uff1a[{}]", writeDatas);
        log.info("\u51c6\u5907\u5199\u5165\u6570\u636e");
        this.writeToExcel(titles, writeDatas, hasTitle, workbook, transverse);
        log.info("\u6807\u9898\u5217\u8868\u4e3a\uff1a[{}]", titles);
        return workbook;
    }

    private Workbook writeToExcel(List<Writer<?>> titles, List<List<Writer<?>>> datas, boolean hasTitle, Workbook workbook, boolean transverse) {
        if (CollectionUtil.safeIsEmpty(datas)) {
            log.warn("\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u5199\u5165\u76f4\u63a5\u8fd4\u56de");
            return workbook;
        }
        log.info("\u5199\u5165excel\uff0c{}\u6807\u9898", (Object)(hasTitle ? "\u9700\u8981" : "\u4e0d\u9700\u8981"));
        Sheet sheet = workbook.createSheet();
        int rowNum = 0;
        if (hasTitle && !CollectionUtil.safeIsEmpty(titles)) {
            log.debug("\u9700\u8981\u6807\u9898\uff0c\u6807\u9898\u4e3a\uff1a{}", titles);
            ArrayList lists = new ArrayList(datas.size() + 1);
            lists.add(titles);
            lists.addAll(datas);
            datas = lists;
        }
        if (transverse) {
            datas = CollectionUtil.matrixTransform(datas);
        }
        for (int i = rowNum; i < rowNum + datas.size(); ++i) {
            Row row = sheet.createRow(i);
            List columnDatas = datas.get(i - rowNum);
            if (CollectionUtil.safeIsEmpty(columnDatas)) continue;
            for (int j = 0; j < columnDatas.size(); ++j) {
                Writer data = (Writer)columnDatas.get(j);
                if (data == null) continue;
                log.debug("\u5199\u5165\u7b2c[{}]\u884c\u7b2c[{}]\u5217\u6570\u636e[{}]", new Object[]{i, j, data.data});
                data.write(row.createCell(j));
            }
        }
        return workbook;
    }

    private Writer<?> build(Object data) {
        Optional<ExcelDataWriter> dataBuilder = this.writers.values().parallelStream().filter(excelData -> excelData.writeable(data)).limit(1L).findFirst();
        ExcelDataWriter writer = dataBuilder.orElseThrow(() -> new UtilsException("\u6570\u636e[" + data + "]\u6ca1\u6709\u5bf9\u5e94\u7684ExcelDataWriter"));
        return new Writer<Object>(writer, data);
    }

    private class Writer<T> {
        private final ExcelDataWriter<T> writer;
        private final T data;

        public void write(Cell cell) {
            this.writer.write(cell, this.data);
        }

        public Writer(ExcelDataWriter<T> writer, T data) {
            this.writer = writer;
            this.data = data;
        }
    }
}

