/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.poi;

import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class CellStyleAccesser {
    private Cell cell;
    private Workbook workbook;
    private CellStyle style;
    private Font font;

    private CellStyleAccesser(Cell cell) {
        this.cell = cell;
        this.workbook = cell.getSheet().getWorkbook();
        this.style = cell.getCellStyle();
        if (this.style.getIndex() == 0) {
            this.style = this.workbook.createCellStyle();
        }
        cell.setCellStyle(this.style);
        this.font = this.style.getFontIndex() == 0 ? this.workbook.createFont() : this.workbook.getFontAt(this.style.getFontIndex());
        this.style.setFont(this.font);
    }

    public static CellStyleAccesser build(Cell cell) {
        return new CellStyleAccesser(cell);
    }

    public CellStyleAccesser setFontSize(short size) {
        this.font.setFontHeightInPoints(size);
        return this;
    }

    public CellStyleAccesser bold(boolean bold) {
        this.font.setBold(bold);
        return this;
    }

    public CellStyleAccesser color(HSSFColor.HSSFColorPredefined color) {
        this.font.setColor(color.getIndex());
        return this;
    }
}

