/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.pattern;

import com.joe.utils.common.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternUtils {
    private static final Pattern IP_PATTERN = Pattern.compile("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}");
    private static final Pattern PHONE_PATTERN = Pattern.compile("^1[3|4|5|7|8]\\d{9}$");
    private static Pattern NUMBER_PARTER = Pattern.compile("-?[1-9]+\\d*(\\.\\d+)");
    private static Pattern NUMBER_STR_PARTER = Pattern.compile("[0-9]+");

    public static boolean isIp(String data) {
        return !StringUtils.isEmpty(data) && PatternUtils.check(data, IP_PATTERN);
    }

    public static boolean isNumberStr(String arg) {
        if (StringUtils.isEmpty(arg)) {
            return false;
        }
        return PatternUtils.check(arg, NUMBER_STR_PARTER);
    }

    public static boolean isNumber(String arg) {
        if (StringUtils.isEmpty(arg)) {
            return false;
        }
        return PatternUtils.check(arg, NUMBER_PARTER);
    }

    public static boolean isPhone(String data) {
        return !StringUtils.isEmpty(data) && PatternUtils.check(data, PHONE_PATTERN);
    }

    private static boolean check(String data, Pattern pattern) {
        if (StringUtils.isEmpty(data)) {
            return false;
        }
        Matcher matcher = pattern.matcher(data);
        return matcher.matches();
    }
}

