/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.parse.xml.converter;

import com.joe.utils.common.BeanUtils;
import com.joe.utils.parse.xml.XmlNode;
import com.joe.utils.parse.xml.XmlTypeConvert;
import com.joe.utils.parse.xml.converter.BooleanConverter;
import com.joe.utils.parse.xml.converter.ByteConverter;
import com.joe.utils.parse.xml.converter.CharConverter;
import com.joe.utils.parse.xml.converter.DoubleConverter;
import com.joe.utils.parse.xml.converter.FloatConverter;
import com.joe.utils.parse.xml.converter.IntConverter;
import com.joe.utils.parse.xml.converter.LongConverter;
import com.joe.utils.parse.xml.converter.ShortConverter;
import com.joe.utils.parse.xml.converter.StringConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTypeConverterUtil {
    private static final Logger logger = LoggerFactory.getLogger(XmlTypeConverterUtil.class);
    public static final Map<String, XmlTypeConvert> converters;
    public static final XmlTypeConvert DEFAULT_CONVERTER;

    public static XmlTypeConvert resolve(XmlNode attrXmlNode, BeanUtils.CustomPropertyDescriptor filed) {
        XmlTypeConvert convert;
        if (attrXmlNode != null) {
            Class<? extends XmlTypeConvert> fieldConverterClass = attrXmlNode.converter();
            if (XmlTypeConvert.class.equals(fieldConverterClass)) {
                convert = XmlTypeConverterUtil.resolve(filed);
            } else {
                try {
                    convert = fieldConverterClass.newInstance();
                }
                catch (Exception e) {
                    convert = XmlTypeConverterUtil.resolve(filed);
                    logger.warn("\u6307\u5b9a\u7684xml\u8f6c\u6362\u5668[{}]\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u8bf7\u4e3a\u8be5\u8f6c\u6362\u5668\u589e\u52a0\u516c\u5171\u65e0\u53c2\u6570\u6784\u9020\u5668\uff0c\u5f53\u524d\u5c06\u4f7f\u7528\u9ed8\u8ba4\u8f6c\u6362\u5668[{}]", new Object[]{fieldConverterClass, convert.getClass(), e});
                }
            }
        } else {
            convert = XmlTypeConverterUtil.resolve(filed);
        }
        return convert;
    }

    public static XmlTypeConvert resolve(BeanUtils.CustomPropertyDescriptor filed) {
        XmlNode xmlnode;
        XmlTypeConvert convert = filed.isGeneralType() || filed.isBasic() ? converters.get(filed.getTypeName()) : (String.class.equals(filed.getRealType()) ? DEFAULT_CONVERTER : (Collection.class.isAssignableFrom(filed.getRealType()) ? ((xmlnode = filed.getAnnotation(XmlNode.class)) == null ? DEFAULT_CONVERTER : xmlnode::general) : filed::getRealType));
        return convert;
    }

    static {
        DEFAULT_CONVERTER = new StringConverter();
        converters = new HashMap<String, XmlTypeConvert>();
        converters.put("byte", new ByteConverter());
        converters.put("short", new ShortConverter());
        converters.put("int", new IntConverter());
        converters.put("long", new LongConverter());
        converters.put("double", new DoubleConverter());
        converters.put("float", new FloatConverter());
        converters.put("boolean", new BooleanConverter());
        converters.put("char", new CharConverter());
        converters.put(Byte.class.getName(), new ByteConverter());
        converters.put(Short.class.getName(), new ShortConverter());
        converters.put(Integer.class.getName(), new IntConverter());
        converters.put(Long.class.getName(), new LongConverter());
        converters.put(Double.class.getName(), new DoubleConverter());
        converters.put(Float.class.getName(), new FloatConverter());
        converters.put(Boolean.class.getName(), new BooleanConverter());
        converters.put(Character.class.getName(), new CharConverter());
    }
}

