/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.parse.xml.converter;

import com.joe.utils.common.StringUtils;
import com.joe.utils.parse.xml.XmlParser;
import com.joe.utils.parse.xml.XmlTypeConvert;
import com.joe.utils.parse.xml.converter.XmlTypeConverterUtil;
import com.joe.utils.type.ReflectUtil;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface XmlConverter<T>
extends XmlTypeConvert<T> {
    public static final Logger logger = LoggerFactory.getLogger(XmlConverter.class);
    public static final XmlParser PARSER = XmlParser.buildInstance();

    @Override
    default public T read(Element element, String attrName) {
        String data = StringUtils.isEmpty(attrName) ? element.asXML() : element.attributeValue(attrName);
        Class clazz = this.resolve();
        if (String.class.equals(clazz)) {
            logger.info("xml\u8f6c\u6362\u5668\u786e\u5b9a\u7684\u5b57\u6bb5\u7c7b\u578b\u4e3aString\uff0c\u8f6c\u5230String\u8f6c\u6362\u5668");
            return (T)data;
        }
        if (ReflectUtil.isBasic(clazz) || ReflectUtil.isGeneralType(clazz)) {
            logger.info("xml\u8f6c\u6362\u5668\u786e\u5b9a\u7684\u5b57\u6bb5\u7c7b\u578b\u4e3a" + clazz.getName() + "\uff0c\u8f6c\u5230\u57fa\u672c\u7c7b\u578b\u8f6c\u6362\u5668");
            return XmlTypeConverterUtil.converters.get(clazz.getName()).read(element, attrName);
        }
        return PARSER.parse(data, clazz);
    }
}

