/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.parse.xml;

import com.joe.utils.collection.CollectionUtil;
import com.joe.utils.common.BeanUtils;
import com.joe.utils.common.StringUtils;
import com.joe.utils.parse.xml.XmlNode;
import com.joe.utils.parse.xml.XmlTypeConvert;
import com.joe.utils.parse.xml.converter.XmlTypeConverterUtil;
import com.joe.utils.type.ReflectUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser {
    private static final Logger log = LoggerFactory.getLogger(XmlParser.class);
    private static final XmlParser DEFAULT = new XmlParser();
    private static final String DEFAULT_ROOT = "root";
    private SAXReader reader = new SAXReader();

    private XmlParser() {
    }

    public static XmlParser getInstance() {
        return DEFAULT;
    }

    public static XmlParser buildInstance() {
        return XmlParser.buildInstance(null);
    }

    public static XmlParser buildInstance(Map<String, Boolean> prop) {
        XmlParser xmlParser = new XmlParser();
        if (!CollectionUtil.safeIsEmpty(prop)) {
            prop.forEach(xmlParser::setFeature);
        }
        return xmlParser;
    }

    public void enableDTD(boolean enable) {
        if (enable) {
            this.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            this.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        } else {
            this.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            this.setFeature("http://xml.org/sax/features/external-general-entities", true);
            this.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
        }
    }

    public void setFeature(String k, boolean enable) {
        try {
            this.reader.setFeature(k, enable);
        }
        catch (SAXException e) {
            throw new RuntimeException("\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25:[" + k + ":" + enable + "]");
        }
    }

    private Document parseText(String text) throws DocumentException {
        String encoding = this.getEncoding(text);
        InputSource source = new InputSource(new StringReader(text));
        source.setEncoding(encoding);
        Document result = this.reader.read(source);
        if (result.getXMLEncoding() == null) {
            result.setXMLEncoding(encoding);
        }
        return result;
    }

    private String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith("<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens.hasMoreTokens()) break;
                result = tokens.nextToken();
                break;
            }
        }
        return result;
    }

    public Map<String, Object> parse(String xml) {
        try {
            Document document = this.parseText(xml);
            Element root = document.getRootElement();
            if (root.elements().size() == 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(root.getName(), root.getText());
                return map;
            }
            return (HashMap)this.parse(root);
        }
        catch (Exception e) {
            log.error("xml\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
            return null;
        }
    }

    public <T> T parse(String xml, Class<T> clazz) {
        Document document;
        T pojo;
        if (xml == null || clazz == null || xml.isEmpty()) {
            return null;
        }
        try {
            pojo = clazz.newInstance();
        }
        catch (Exception e) {
            log.error("class\u5bf9\u8c61\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\uff1b\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            document = this.parseText(xml);
        }
        catch (Exception e) {
            log.error("xml\u89e3\u6790\u9519\u8bef", (Throwable)e);
            return null;
        }
        BeanUtils.CustomPropertyDescriptor[] propertyDescriptor = BeanUtils.getPropertyDescriptors(clazz);
        Element root = document.getRootElement();
        for (BeanUtils.CustomPropertyDescriptor descript : propertyDescriptor) {
            List nodes;
            XmlNode xmlNode = descript.getAnnotation(XmlNode.class);
            String fieldName = descript.getName();
            String nodeName = null;
            String attributeName = null;
            boolean isParent = false;
            boolean ignore = false;
            if (xmlNode == null) {
                nodeName = fieldName;
            } else if (!xmlNode.ignore()) {
                nodeName = StringUtils.isEmpty(xmlNode.name()) ? fieldName : xmlNode.name();
                log.debug("\u5b57\u6bb5[{}]\u5bf9\u5e94\u7684\u8282\u70b9\u540d\u4e3a\uff1a{}", (Object)fieldName, (Object)nodeName);
                if (xmlNode.isAttribute()) {
                    if (StringUtils.isEmpty(xmlNode.attributeName())) {
                        log.warn("\u5b57\u6bb5[{}]\u662f\u5c5e\u6027\u503c\uff0c\u4f46\u662f\u672a\u8bbe\u7f6e\u5c5e\u6027\u540d\uff08attributeName\u5b57\u6bb5\uff09\uff0c\u5c06\u91c7\u7528\u5b57\u6bb5\u540d\u4f5c\u4e3a\u5c5e\u6027\u540d", (Object)descript.getName());
                        attributeName = fieldName;
                    } else {
                        attributeName = xmlNode.attributeName();
                    }
                    if (StringUtils.isEmpty(xmlNode.name())) {
                        log.debug("\u8be5\u5b57\u6bb5\u662f\u5c5e\u6027\u503c\uff0c\u5e76\u4e14\u672a\u8bbe\u7f6e\u8282\u70b9\u540d\uff08name\u5b57\u6bb5\uff09\uff0c\u8bbe\u7f6eisParent\u4e3atrue");
                        isParent = true;
                    }
                } else {
                    log.debug("\u5b57\u6bb5[{}]\u5bf9\u5e94\u7684\u662f\u8282\u70b9");
                }
            } else {
                ignore = true;
            }
            if (ignore) continue;
            List list = nodes = !StringUtils.isEmpty(attributeName) && isParent ? Collections.singletonList(root) : root.elements(nodeName);
            if (nodes.isEmpty()) {
                nodes = root.elements(StringUtils.toFirstUpperCase(nodeName));
            }
            if (nodes.isEmpty()) continue;
            Class<?> type = descript.getRealType();
            if (Collection.class.isAssignableFrom(type)) {
                this.setValue(nodes, attributeName, pojo, descript);
                continue;
            }
            if (Map.class.isAssignableFrom(type)) {
                log.warn("\u5f53\u524d\u6682\u65f6\u4e0d\u652f\u6301\u89e3\u6790map");
                continue;
            }
            this.setValue((Element)nodes.get(0), attributeName, pojo, descript);
        }
        return pojo;
    }

    public String toXml(Object source) {
        return this.toXml(source, null, false);
    }

    public String toXml(Object source, String rootName, boolean hasNull) {
        if (source == null) {
            log.warn("\u4f20\u5165\u7684source\u4e3anull\uff0c\u8fd4\u56denull");
            return null;
        }
        if (rootName == null) {
            XmlNode xmlNode = source.getClass().getDeclaredAnnotation(XmlNode.class);
            String string = rootName = xmlNode == null ? null : xmlNode.name();
        }
        if (rootName == null) {
            rootName = DEFAULT_ROOT;
        }
        Long start = System.currentTimeMillis();
        Element root = DocumentHelper.createElement((String)rootName);
        this.buildDocument(root, source, source.getClass(), !hasNull);
        Long end = System.currentTimeMillis();
        log.debug("\u89e3\u6790xml\u7528\u65f6" + (end - start) + "ms");
        return root.asXML();
    }

    private void buildDocument(Element parent, Object pojo, Class<?> clazz, boolean ignoreNull) {
        HashMap<String, XmlData> map = new HashMap<String, XmlData>();
        if (pojo instanceof Map) {
            Map pojoMap = (Map)pojo;
            pojoMap.forEach((k, v) -> {
                if (k == null) {
                    log.debug("\u5ffd\u7565map\u4e2dkey\u4e3anull\u7684\u503c");
                } else if (ignoreNull && v == null) {
                    log.debug("\u5f53\u524d\u914d\u7f6e\u4e3a\u5ffd\u7565\u7a7a\u503c\uff0c[{}]\u7684\u503c\u4e3a\u7a7a\uff0c\u5ffd\u7565", k);
                } else {
                    map.put(String.valueOf(k), new XmlData(null, v, v == null ? null : v.getClass()));
                }
            });
        } else {
            BeanUtils.CustomPropertyDescriptor[] propertyDescriptors;
            for (BeanUtils.CustomPropertyDescriptor descriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors(clazz == null ? pojo.getClass() : clazz)) {
                Object valueObj;
                XmlNode xmlNode = descriptor.getAnnotation(XmlNode.class);
                Object v0 = valueObj = pojo == null ? null : BeanUtils.getProperty(pojo, descriptor.getName());
                if (ignoreNull && valueObj == null || xmlNode != null && xmlNode.ignore()) {
                    log.debug("\u5ffd\u7565\u7a7a\u8282\u70b9\u6216\u8005\u8282\u70b9\u88ab\u6ce8\u89e3\u5ffd\u7565");
                    continue;
                }
                String nodeName = xmlNode == null || StringUtils.isEmpty(xmlNode.name()) ? descriptor.getName() : xmlNode.name();
                map.put(nodeName, new XmlData(xmlNode, valueObj, descriptor.getRealType()));
            }
        }
        map.forEach((k, v) -> {
            XmlNode xmlNode = v.getXmlNode();
            Object valueObj = v.getData();
            String nodeName = k;
            String attrName = xmlNode == null || StringUtils.isEmpty(xmlNode.attributeName()) ? nodeName : xmlNode.attributeName();
            boolean isCDATA = xmlNode != null && xmlNode.isCDATA();
            Class<?> type = v.getType();
            Element node = parent.element(nodeName);
            if (node == null) {
                node = DocumentHelper.createElement((String)nodeName);
                parent.add(node);
            }
            if (xmlNode != null && xmlNode.isAttribute()) {
                String attrValue;
                String string = attrValue = valueObj == null ? "" : String.valueOf(valueObj);
                if (StringUtils.isEmpty(xmlNode.name())) {
                    parent.remove(node);
                    node = parent;
                }
                node.addAttribute(attrName, attrValue);
            } else if (type == null) {
                log.debug("\u5f53\u524d\u4e0d\u77e5\u9053\u8282\u70b9[{}]\u7684\u7c7b\u578b\uff0c\u5ffd\u7565\u8be5\u8282\u70b9", k);
            } else if (ReflectUtil.isSimple(type)) {
                if (Map.class.isAssignableFrom(type)) {
                    log.warn("\u5f53\u524d\u5b57\u6bb5[{}]\u662fmap\u7c7b\u578b", k);
                    this.buildDocument(node, v.getData(), type, ignoreNull);
                } else if (Collection.class.isAssignableFrom(type)) {
                    parent.remove(node);
                    if (valueObj != null) {
                        Element root;
                        String arrayNodeName;
                        if (StringUtils.isEmpty(xmlNode.arrayRoot())) {
                            arrayNodeName = nodeName;
                            root = parent;
                        } else {
                            arrayNodeName = xmlNode.arrayRoot();
                            root = DocumentHelper.createElement((String)nodeName);
                            parent.add(root);
                        }
                        Collection collection = (Collection)valueObj;
                        collection.stream().forEach(obj -> {
                            Element n = DocumentHelper.createElement((String)arrayNodeName);
                            root.add(n);
                            this.buildDocument(n, obj, null, ignoreNull);
                        });
                    }
                } else {
                    String text;
                    String string = text = valueObj == null ? "" : String.valueOf(valueObj);
                    if (isCDATA) {
                        log.debug("\u5185\u5bb9[{}]\u9700\u8981CDATA\u6807\u7b7e\u5305\u88f9", (Object)text);
                        node.add(DocumentHelper.createCDATA((String)text));
                    } else {
                        node.setText(text);
                    }
                }
            } else {
                Class<?> realType = this.resolveRealType(type, xmlNode);
                this.buildDocument(node, valueObj, realType, ignoreNull);
            }
        });
    }

    private Class<?> resolveRealType(Class<?> fieldType, XmlNode xmlNode) {
        Class<?> type;
        Class<?> clazz = type = xmlNode == null || xmlNode.general() == null ? fieldType : xmlNode.general();
        if (!fieldType.isAssignableFrom(type)) {
            type = fieldType;
        }
        return type;
    }

    private Object parse(Element element) {
        List elements = element.elements();
        if (elements.size() == 0) {
            return element.getText();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Element ele : elements) {
            Object result = this.parse(ele);
            if (map.containsKey(ele.getName())) {
                List<String> list;
                Object obj = map.get(ele.getName());
                if (obj != null && obj instanceof List) {
                    list = (List)obj;
                } else {
                    list = new ArrayList<String>();
                    list.add(obj == null ? null : String.valueOf(obj));
                }
                list.add(result == null ? null : String.valueOf(result));
                map.put(ele.getName(), list);
                continue;
            }
            map.put(ele.getName(), result);
        }
        return map;
    }

    private void setValue(Element element, String attrName, Object pojo, BeanUtils.CustomPropertyDescriptor field) {
        XmlNode attrXmlNode = field.getAnnotation(XmlNode.class);
        log.debug("\u8981\u8d4b\u503c\u7684fieldName\u4e3a{}", (Object)field.getName());
        XmlTypeConvert convert = XmlTypeConverterUtil.resolve(attrXmlNode, field);
        if (!BeanUtils.setProperty(pojo, field.getName(), convert.read(element, attrName))) {
            log.warn("copy\u4e2d\u590d\u5236{}\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u5c5e\u6027[{}]\u7684\u503c\u5c06\u88ab\u5ffd\u7565", (Object)field.getName(), (Object)field.getName());
        }
    }

    private void setValue(List<Element> elements, String attrName, Object pojo, BeanUtils.CustomPropertyDescriptor field) {
        List list;
        Class<Object> collectionClass;
        XmlNode attrXmlNode = field.getAnnotation(XmlNode.class);
        log.debug("\u8981\u8d4b\u503c\u7684fieldName\u4e3a{}", (Object)field.getName());
        XmlTypeConvert convert = XmlTypeConverterUtil.resolve(attrXmlNode, field);
        Class<Object> real = field.getRealType();
        if (attrXmlNode != null) {
            collectionClass = attrXmlNode.arrayType();
            if (!collectionClass.equals(real) && !real.isAssignableFrom(collectionClass)) {
                log.warn("\u7528\u6237\u6307\u5b9a\u7684\u96c6\u5408\u7c7b\u578b[{}]\u4e0d\u662f\u5b57\u6bb5\u7684\u5b9e\u9645\u96c6\u5408\u7c7b\u578b[{}]\u7684\u5b50\u7c7b\uff0c\u4f7f\u7528\u5b57\u6bb5\u7684\u5b9e\u9645\u96c6\u5408\u7c7b\u578b", collectionClass, real);
                collectionClass = real;
            }
        } else {
            collectionClass = real;
        }
        if (!StringUtils.isEmpty(attrXmlNode.arrayRoot()) && !elements.isEmpty()) {
            elements = elements.get(0).elements(attrXmlNode.arrayRoot());
        }
        if (!this.trySetValue(list = elements.stream().map(d -> convert.read((Element)d, attrName)).collect(Collectors.toList()), pojo, field, collectionClass) && !this.trySetValue(list, pojo, field, real)) {
            log.warn("\u65e0\u6cd5\u4e3a\u5b57\u6bb5[{}]\u8d4b\u503c", (Object)field.getName());
        }
    }

    private boolean trySetValue(List<?> datas, Object pojo, BeanUtils.CustomPropertyDescriptor field, Class<? extends Collection> clazz) {
        log.debug("\u8981\u8d4b\u503c\u7684fieldName\u4e3a{}", (Object)field.getName());
        Collection collection = this.tryBuildCollection(clazz);
        if (collection == null) {
            log.warn("\u65e0\u6cd5\u4e3aclass[{}]\u6784\u5efa\u5b9e\u4f8b", clazz);
            return false;
        }
        collection.addAll(datas);
        try {
            return BeanUtils.setProperty(pojo, field.getName(), collection);
        }
        catch (Exception e) {
            log.debug("\u5b57\u6bb5[{}]\u8d4b\u503c\u5931\u8d25\uff0c\u4f7f\u7528\u7684\u96c6\u5408\u7c7b\u4e3a[{}]", new Object[]{field.getName(), clazz, e});
            return false;
        }
    }

    private Collection tryBuildCollection(Class<? extends Collection> clazz) {
        if (clazz.equals(List.class)) {
            return new ArrayList();
        }
        if (clazz.equals(Set.class)) {
            return new HashSet();
        }
        if (List.class.isAssignableFrom(clazz)) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                log.warn("\u6307\u5b9aclass[{}]\u65e0\u6cd5\u521b\u5efa\u5bf9\u8c61\uff0c\u8bf7\u4e3a\u5176\u6dfb\u52a0\u516c\u5171\u65e0\u53c2\u6570\u6784\u9020\u5668\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u5b9e\u73b0ArrayList", clazz, (Object)e);
                return new ArrayList();
            }
        }
        if (Set.class.isAssignableFrom(clazz)) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                log.warn("\u6307\u5b9aclass[{}]\u65e0\u6cd5\u521b\u5efa\u5bf9\u8c61\uff0c\u8bf7\u4e3a\u5176\u6dfb\u52a0\u516c\u5171\u65e0\u53c2\u6570\u6784\u9020\u5668\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u5b9e\u73b0HashSet", clazz, (Object)e);
                return new HashSet();
            }
        }
        log.warn("\u672a\u77e5\u96c6\u5408\u7c7b\u578b\uff1a[{}]", clazz);
        return null;
    }

    static {
        DEFAULT.enableDTD(false);
    }

    private static class XmlData {
        private XmlNode xmlNode;
        private Object data;
        private Class<?> type;

        public XmlData(Object data) {
            this.data = data;
        }

        public XmlNode getXmlNode() {
            return this.xmlNode;
        }

        public Object getData() {
            return this.data;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setXmlNode(XmlNode xmlNode) {
            this.xmlNode = xmlNode;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XmlData)) {
                return false;
            }
            XmlData other = (XmlData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            XmlNode this$xmlNode = this.getXmlNode();
            XmlNode other$xmlNode = other.getXmlNode();
            if (this$xmlNode == null ? other$xmlNode != null : !this$xmlNode.equals(other$xmlNode)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XmlData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            XmlNode $xmlNode = this.getXmlNode();
            result = result * 59 + ($xmlNode == null ? 43 : $xmlNode.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "XmlParser.XmlData(xmlNode=" + this.getXmlNode() + ", data=" + this.getData() + ", type=" + this.getType() + ")";
        }

        public XmlData(XmlNode xmlNode, Object data, Class<?> type) {
            this.xmlNode = xmlNode;
            this.data = data;
            this.type = type;
        }
    }
}

