/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.parse.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonParser {
    private static final Logger log = LoggerFactory.getLogger(JsonParser.class);
    private static final JsonParser JSON_PARSER;
    private static final ObjectMapper MAPPER_IGNORE_NULL;
    private static final ObjectMapper MAPPER;

    private JsonParser() {
    }

    public static JsonParser getInstance() {
        return JSON_PARSER;
    }

    public String toJson(Object obj) {
        return this.toJson(obj, false);
    }

    public String toJson(Object obj, boolean ignoreNull) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            ObjectMapper mapper = ignoreNull ? MAPPER_IGNORE_NULL : MAPPER;
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("\u5e8f\u5217\u5316\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            return "";
        }
    }

    public <T> T readAsObject(String content, Class<T> type) {
        try {
            if (content == null || content.isEmpty() || type == null) {
                log.debug("content\u4e3a{}\uff0ctype\u4e3a\uff1a{}", (Object)content, type);
                return null;
            }
            if (type.equals(String.class)) {
                return (T)content;
            }
            return (T)MAPPER.readValue(content, type);
        }
        catch (Exception e) {
            log.error("json\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            return null;
        }
    }

    public <T> T readAsObject(byte[] content, Class<T> type) {
        try {
            if (content == null || content.length == 0 || type == null) {
                log.debug("content\u4e3a{}\uff0ctype\u4e3a\uff1a{}", (Object)content, type);
                return null;
            }
            if (type.equals(String.class)) {
                return (T)new String(content);
            }
            return (T)MAPPER.readValue(content, type);
        }
        catch (Exception e) {
            log.error("json\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            return null;
        }
    }

    public <T extends Map<K, V>, K, V> T readAsMap(String content, Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType) {
        try {
            MapType type = MAPPER.getTypeFactory().constructMapType(mapType, keyType, valueType);
            return (T)((Map)MAPPER.readValue(content, (JavaType)type));
        }
        catch (Exception e) {
            log.error("json\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            return null;
        }
    }

    public <T extends Map<K, V>, K, V> T readAsMap(byte[] content, Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType) {
        return this.readAsMap(new String(content), mapType, keyType, valueType);
    }

    public <T extends Collection<V>, V> T readAsCollection(String content, Class<? extends Collection> collectionType, Class<V> elementsType) {
        try {
            CollectionLikeType type = MAPPER.getTypeFactory().constructCollectionLikeType(collectionType, elementsType);
            return (T)((Collection)MAPPER.readValue(content, (JavaType)type));
        }
        catch (Exception e) {
            log.error("json\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            return null;
        }
    }

    public <T extends Collection<V>, V> T readAsCollection(byte[] content, Class<? extends Collection> collectionType, Class<V> elementsType) {
        return this.readAsCollection(new String(content), collectionType, elementsType);
    }

    static {
        MAPPER = new ObjectMapper();
        MAPPER_IGNORE_NULL = new ObjectMapper();
        MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        MAPPER_IGNORE_NULL.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JSON_PARSER = new JsonParser();
    }
}

