/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.monitor;

import com.joe.utils.common.IOUtils;
import com.joe.utils.monitor.ClassLoadInfo;
import com.joe.utils.monitor.JVMMemoryInfo;
import com.joe.utils.monitor.MemoryInfo;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Manager {
    public static ClassLoadInfo classLoadManager() {
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        int nowLoadedClassCount = classLoadingMXBean.getLoadedClassCount();
        long totalLoadedClassCount = classLoadingMXBean.getTotalLoadedClassCount();
        long unloadedClassCount = classLoadingMXBean.getUnloadedClassCount();
        return new ClassLoadInfo(nowLoadedClassCount, totalLoadedClassCount, unloadedClassCount);
    }

    public static JVMMemoryInfo getJVMMemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        double freeMemory = (double)runtime.freeMemory() / 1048576.0;
        double maxMemory = (double)runtime.maxMemory() / 1048576.0;
        double totalMemory = (double)runtime.totalMemory() / 1048576.0;
        return new JVMMemoryInfo(freeMemory, maxMemory, totalMemory);
    }

    public static List<MemoryInfo> getMemoryInfo() {
        TreeMap<String, MemoryUsage> map = new TreeMap<String, MemoryUsage>();
        List<MemoryPoolMXBean> memoryPoolMXBeanList = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<MemoryInfo> memoryInfoList = new ArrayList<MemoryInfo>();
        for (MemoryPoolMXBean bean : memoryPoolMXBeanList) {
            String name = bean.getName();
            MemoryUsage memoryUsage = bean.getUsage();
            map.put(name, memoryUsage);
        }
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        map.put("heapMemory", bean.getHeapMemoryUsage());
        map.put("nonHeapMemory", bean.getNonHeapMemoryUsage());
        for (Map.Entry entity : map.entrySet()) {
            String name = (String)entity.getKey();
            MemoryUsage memoryUsage = (MemoryUsage)entity.getValue();
            double init = (double)memoryUsage.getInit() / 1048576.0;
            double max = (double)memoryUsage.getMax() / 1048576.0;
            double used = (double)memoryUsage.getUsed() / 1048576.0;
            double committed = (double)memoryUsage.getCommitted() / 1048576.0;
            MemoryInfo info = new MemoryInfo(name, init, used, committed, max);
            memoryInfoList.add(info);
        }
        return memoryInfoList;
    }

    public static double getSystemMemoryInfo() throws Exception {
        String[] results;
        int total = 0;
        Process process = Runtime.getRuntime().exec("tasklist");
        String result = IOUtils.read(process.getInputStream(), Charset.defaultCharset().name());
        for (String str : results = result.split("\\n")) {
            Pattern pattern = Pattern.compile(".*\\s([0-9]{0,},[0-9]+)\\sK.*");
            Matcher matcher = pattern.matcher(str);
            if (!matcher.find()) continue;
            String memorySizeStr = matcher.group(1).replace(",", "");
            int memorySize = Integer.parseInt(memorySizeStr);
            total += memorySize;
        }
        return (double)total / 1024.0;
    }
}

