/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.math;

import com.joe.utils.math.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MathUtil {
    public static final double ANGLE_30 = 0.5235987755982988;
    public static final double ANGLE_45 = 0.7853981633974483;
    public static final double ANGLE_60 = 1.0471975511965976;
    public static final double ANGLE_90 = 1.5707963267948966;
    public static final double ANGLE_120 = 2.0943951023931953;
    public static final double ANGLE_135 = 2.356194490192345;
    public static final double ANGLE_150 = 2.6179938779914944;
    public static final double ANGLE_180 = Math.PI;
    public static final double ANGLE_270 = 4.71238898038469;
    public static final double ANGLE_360 = Math.PI * 2;
    public static final double SIN_30 = 0.5;
    public static final double SIN_45 = Math.sqrt(2.0) / 2.0;
    public static final double SIN_60;
    public static final double SIN_90 = 1.0;
    public static final double SIN_120;
    public static final double SIN_135;
    public static final double SIN_150 = 0.5;
    public static final double SIN_180 = 0.0;
    public static final double SIN_270 = -1.0;
    public static final double SIN_360 = 0.0;
    public static final double COS_30;
    public static final double COS_45;
    public static final double COS_60 = 0.0;
    public static final double COS_90 = 0.0;
    public static final double COS_120 = -0.0;
    public static final double COS_135;
    public static final double COS_150;
    public static final double COS_180 = -1.0;
    public static final double COS_270 = 0.0;
    public static final double COS_360 = 1.0;

    private MathUtil() {
    }

    public static Point spin(Point point, double angle) {
        return MathUtil.spin(Collections.singletonList(point), angle).get(0);
    }

    public static List<Point> spin(Point[] points, double angle) {
        return MathUtil.spin(Arrays.asList(points), angle);
    }

    public static List<Point> spin(Collection<Point> points, double angle) {
        double COS;
        double SIN;
        if (angle == 0.5235987755982988) {
            SIN = 0.5;
            COS = COS_30;
        } else if (angle == 0.7853981633974483) {
            SIN = SIN_45;
            COS = COS_45;
        } else if (angle == 1.0471975511965976) {
            SIN = SIN_60;
            COS = 0.0;
        } else if (angle == 1.5707963267948966) {
            SIN = 1.0;
            COS = 0.0;
        } else if (angle == 2.0943951023931953) {
            SIN = SIN_120;
            COS = -0.0;
        } else if (angle == 2.356194490192345) {
            SIN = SIN_135;
            COS = COS_135;
        } else if (angle == 2.6179938779914944) {
            SIN = 0.5;
            COS = COS_150;
        } else if (angle == Math.PI) {
            SIN = 0.0;
            COS = -1.0;
        } else if (angle == 4.71238898038469) {
            SIN = -1.0;
            COS = 0.0;
        } else if (angle == Math.PI * 2) {
            SIN = 0.0;
            COS = 1.0;
        } else {
            SIN = Math.sin(angle);
            COS = Math.cos(angle);
        }
        ArrayList<Point> result = new ArrayList<Point>(points.size());
        points.parallelStream().forEach(point -> {
            double x = point.getX();
            double y = point.getY();
            double newX = x * COS - y * SIN;
            double newY = x * SIN - y * COS;
            result.add(new Point(newX, newY));
        });
        return result;
    }

    public static long factorial(int arg) {
        if (arg <= 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        long result = 1L;
        for (int i = arg; i > 0; --i) {
            result *= (long)i;
        }
        return result;
    }

    static {
        SIN_120 = SIN_60 = Math.sqrt(3.0) / 2.0;
        SIN_135 = SIN_45;
        COS_30 = Math.sqrt(3.0) / 2.0;
        COS_45 = Math.sqrt(2.0) / 2.0;
        COS_135 = -COS_45;
        COS_150 = -COS_30;
    }
}

